#include "MainWindow.h"

MainWindow::MainWindow(QDesktopWidget *desktop) :
  QMainWindow(desktop)
{
    this->viewer = new QDeclarativeView;

    this->viewer->setSource(QString("qrc:TweedUI/main-maemo.qml"));
    // this->notty = new Notty; // Notification object
    this->viewer->rootContext()->setContextProperty("Notty", this); // register notification to Qml
    this->viewer->rootContext()->setContextProperty("View", this);
    this->viewer->setWindowTitle("Tweed Suit");
    this->viewer->setResizeMode(QDeclarativeView::SizeRootObjectToView);
    // setGeometry(desktop->availableGeometry());
#if defined(USE_OPENGL)
    QApplication::setGraphicsSystem("opengl");
    // QGLFormat format = QGLFormat::defaultFormat();
    // format.setSampleBuffers(false);
    this->glWidget = new QGLWidget;
    // glWidget->setAutoFillBackground(false);
    this->viewer->setViewport(glWidget);
#endif
#if defined(Q_WS_MAEMO_5)
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    this->interface  = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                            MCE_REQUEST_IF, QDBusConnection::systemBus(),
                                            this);
#endif
    setCentralWidget(this->viewer);
}

void MainWindow::notify(const QString &title, const QString &text) {
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    QDBusConnection::sessionBus().registerService(APP_DBUS_SERVICE);
    QDBusConnection::sessionBus().registerObject(APP_DBUS_PATH, this, QDBusConnection::ExportScriptableSlots);
    this->dbusMessage = new QDBusMessage(QDBusMessage::createMethodCall(APP_DBUS_SERVICE, APP_DBUS_PATH, APP_DBUS_INTERFACE, "activate_application"));

    QList<StringPair> notificationHints;
    notificationHints.append(StringPair("led-pattern", "PatternCommunicationEmail"));
    Maemo5DeviceEvents e;
    if (QApplication::focusWidget() != NULL && !e.isScreenLocked()) {
       QMaemo5InformationBox::information(0, text, QMaemo5InformationBox::DefaultTimeout);
    } else {
       QMaemo5Notification::nonExpiringInformation(text, title, dbusMessage, notificationHints, "tweedsuit-icon");
       // this->notification = new QeMaemo5Notification(text, 0, title, QeMaemo5Notification::EXPIRES_NEVER);
    }
//               } else {


                   /*
    QString text();
    QString title();
QeMaemo5Notification(const QString &text,
    QObject *parent = 0,
    const QString &title = QApplication::applicationName(),
    int timeout = DEFAULT_TIMEOUT,
    const QList<QeStringPair> &hints = QList<QeStringPair>(),
    const QString &icon = applicationIcon());

                     */
               //

#if defined(Q_WS_MAEMO_5)
    QDBusMessage reply = this->interface->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternChatAndEmail");
    if (reply.type() == QDBusMessage::ErrorMessage)
        qDebug() << reply.errorMessage();
#endif
#else
#if !defined(Q_WS_WIN)
           NotifyNotification *notifi;
           notifi = notify_notification_new(title.toLatin1().data(), text.toLatin1().data(), NULL, NULL);
           if (notifi) {
               notify_notification_set_timeout(notifi, 2200);
               if (!notify_notification_show(notifi, NULL))
                           qDebug("Failed to send notification");
               g_object_unref(notifi);

           } else {
               qDebug("there was a problem with notification init");
           }
#endif
#endif
}


MainWindow::~MainWindow()
{
      delete this->viewer;
#if defined(Q_WS_MAEMO_5)
           QDBusMessage reply;

           reply = interface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternChatAndEmail");
           if (reply.type() == QDBusMessage::ErrorMessage)
               qDebug() << reply.errorMessage();
#endif
}
