import QtQuick 1.0
// import com.nokia.meego 1.0
import QtWebKit 1.0
import "js/OAuth.js" as OAuthLogic

Item{
    id: root
    width: 800
    height: 420
    property string username: ''
    property string password: ''
    property string token: ""
    property string secret:""
    property int tests: 0
    function beginAuthentication() {
        loading.loadtext = "Requesting token"
        loading.state = "visible";

        step = 1;
        stepOne();
    }
    signal authenticationCompleted;
    signal authenticationFailed;
    //property var credentials: new Object
    property int step: 0
    function nextStep(){
        if(step == 1)
            stepOne();
        else if(step == 2)
            stepTwo();
        else if(step == 3)
            stepThree();
        return;
    }
    function stepOne() {
        console.log("step one starts");
        var xhr = OAuthLogic.createOAuthHeader("POST", "https://api.twitter.com/oauth/request_token", [["oauth_callback","oob"]]);
        xhr.onreadystatechange = function() { 
            if (xhr.readyState == XMLHttpRequest.DONE) {

                // console.log(xhr.status+'\n'+xhr.getAllResponseHeaders()+'\n'+xhr.responseText);
                var response = xhr.responseText.split('&');
                if(response.length != 3)
                    return;
                token = response[0].split('=')[1];
                secret = response[1].split('=')[1];
                if(response[2].split('=')[1] != 'true')
                    console.log("Error: " + response[2]);
                step = 2;
                console.log("https://api.twitter.com/oauth/authorize?oauth_token="+token);
                webItem.url = "https://api.twitter.com/oauth/authorize?oauth_token="+token;
                // Qt.openUrlExternally("https://api.twitter.com/oauth/authorize?oauth_token="+token);

            }
        }
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.setRequestHeader("Accept-Language", "en");
        xhr.send();
    }
    function stepTwo(){
        loading.loadtext = "Logging in"

        step = 3;
        var page = webItem.html;
        console.log("Step2\n"+username);
        webItem.evaluateJavaScript("document.getElementById(\"username_or_email\").value = \"" + username + "\";");
        webItem.evaluateJavaScript("document.getElementById(\"password\").value = \"" + password + "\";");
        webItem.evaluateJavaScript("document.getElementById(\"session\[password\]\").value = \"" + password + "\";");
        webItem.evaluateJavaScript("document.getElementById(\"allow\").click();");
//
//        webItem.evaluateJavaScript("document.getElementsByTagName(\"input\")[5].click();");
        console.log("waiting for reply to get to step 3");
    }
    function stepThree(){
        console.log("stating step 3");
        if (webItem.evaluateJavaScript("document.getElementById(\"oauth_pin\").innerHTML;")) {
            var tmp = webItem.evaluateJavaScript("document.getElementById(\"oauth_pin\").innerHTML;").replace(/[^0-9]*/g, "")
            console.log("pin:" + tmp);
            var pin = tmp.substring(tmp.length - 7);
            console.log("pin2: " + pin)
        } else {
            loading.loadtext = "Authentication failed"
            // loading.state = "hidden"
            console.log("auth failed");
            authenticationFailed();
            return false;
        }
        console.log("pin: " + pin);
        var xhr = OAuthLogic.createOAuthHeader("POST", "https://api.twitter.com/oauth/access_token", [["oauth_verifier",pin]], {"token":token,"secret":secret});
        xhr.onreadystatechange = function() {
            if (xhr.readyState == XMLHttpRequest.DONE) {
                console.log('STEP 3\n'+xhr.status+'\n'+xhr.getAllResponseHeaders()+'\n'+xhr.responseText+xhr.responseXML);
                console.log('STEP 3\n');
                var response = xhr.responseText.split('&');
                if(response.length != 4)
                    return;
                token = response[0].split('=')[1];
                secret = response[1].split('=')[1];
                //username = respones[3].split('=')[1];
                step = 0;
                authorized = true;
                loading.loadtext = "Authenticaticated!"
                // loading.state = "hidden"
                authBox.usernamefield = username;
                screen.js().twitterusername = username;
                authenticationCompleted();
            }
        }
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.setRequestHeader("Accept-Language", "en");
        xhr.send();
    }
    property bool authorized: false
    WebView {
        id: webItem
        url: "about:blank"
        opacity: 0
        onLoadFinished: nextStep();
        anchors.fill: parent;
    }
}
