import QtQuick 1.0
// import com.nokia.meego 1.0

Rectangle {
    property string loadtext: "Loading..."
    signal done
    id: loadingBox
    z: 5
    y: Math.floor((parent.height / 2) - (loadingBox.height / 2) - 20)
    anchors.horizontalCenter: parent.horizontalCenter;
    width: 300
    height: 200
    // anchors.centerIn: parent
    radius: 5
    smooth: true
    border.width: 1
    border.color: "grey"
    gradient: boxgrad
    opacity: 0
    Gradient {
        id: boxgrad
        GradientStop { position: 0.0; color: "darkgrey" }
        GradientStop { position: 1.0; color: "grey" }
    }
    Image {
        anchors.fill: parent
        source: "images/tweed_bg.png"
        fillMode: Image.Tile
        opacity: 0.15
    }
    Row {
        anchors.centerIn: parent;
        spacing: 5
        Image {
            source: "images/tweedsuit-icon.png"
            width: 25
            height: 25
            fillMode: Image.PreserveAspectFit
            smooth: true
        }
        Text {
            y: 8
            text: "Tweed Suit"
            font.pointSize: 15
            font.weight: Font.Bold
        }
    }

    Text {
        text: loadtext
        font.pointSize: 12
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 10
        anchors.left: parent.left
        anchors.leftMargin: 15
        // font.weight: Font.Bold
    }
    states: [
        State {
            name: "visible"
            PropertyChanges {
                target: loadingBox
                opacity: 1
            }
        },
        State {
            name: "hidden"
            PropertyChanges {
                target: loadingBox
                opacity: 0
            }
            StateChangeScript { script: done() }
        }

    ]
    Behavior on opacity {
        NumberAnimation { duration: 500 }
    }
    MouseArea {
        anchors.fill: parent
        onClicked: {
            loadingBox.opacity = 0
        }
    }
}
