import QtQuick 1.0
Rectangle {
    property alias headline: hd.text
    property alias infotext: info.text
    property alias bgimage: bgimage.source
    property alias state: topbar.state
    property string type: "search"
    signal closeClicked
    signal refreshClicked
    signal moverightClicked
    signal moveleftClicked
    id: topbar
    width: 373
    height: 45
    color: "black"
    clip: true

    Text { // headline text
        anchors.verticalCenter: top.verticalCenter
        id: hd
        font.weight: Font.Light
        font.pointSize: 15
        color: "black"
        text: ""
        z: 3
        x: 10
        width: 280
        clip: true
    }


    Rectangle { // Loading bar
        x: 0; y: 45
        width:  373
        height: 55
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        id: refreshing
        AnimatedImage {
            id: loaderimage
            anchors.centerIn: parent
            source: (refreshing.opacity == 0) ? "" : "images/loading_small.gif";
        }

        Behavior on opacity {
            NumberAnimation { duration: 300 }
        }
    }
    Behavior on height {
        NumberAnimation { duration: 200; }
    }



    Image { // moving background
        z: 1
        id: bgimage
        // source: screen.js().getBgSource(type);
        x: -140
        y: -110
        smooth: true
        Behavior on x {
            NumberAnimation { duration: 10000; }
        }
        Behavior on y {
            NumberAnimation { duration: 10000; }
        }
        states: [
            State {
                name: "out"
                when: topbar.height > 45
                PropertyChanges {
                    target: bgimage
                    x: -20
                    y: -50
                }
            },
            State {
                name: "in"
                when: topbar.height <= 45
                PropertyChanges {
                    target: bgimage
                    x: -140
                    y: -110
                }
            }
        ]
    }

    Rectangle { // top bar.
        id: top
        x: 0; y: 0
        width: 373;
        height: 45;
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        //color: "#eee"
        MouseArea {
            anchors.fill:  parent
            onClicked: {
                // topbar.moverightClicked()
                if (topbar.height > 45) {
                    topbar.state = ""
                    bgimage.state = ""
                } else {
                    topbar.state = "open"
                    bgimage.state = "out"
                }
            }
            onPressAndHold: {
                // console.log("loaderimage.source: " + loaderimage.source)
                topbar.state = "edit"
            }
        }
    }


    NewButton {
        x: 285; y: 0
        z: 3
        id: refresh
        useimg: true
        bsource: "images/refresh.png"
        onClicked: { topbar.refreshClicked() }
    }

    NewButton {
        x: 325; y: 0
        z: 3
        id: close
        useimg: true
        bsource: "images/close.png"
        onClicked: { topbar.closeClicked() }
    }

    Rectangle { // info bar background
        id: infocontainer
        z: 0
        x: 0
        y: 45
        width: 373
        height: topbar.height - 45
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        opacity: 0
    }
    Text { // dropdown info text
        id: info
        z: 3
        x: 10
        y: 50
        font.pointSize: 12 + fontsize
        font.weight: Font.Light
        color: "black"
        wrapMode: Text.WordWrap
        textFormat: Text.RichText
        onLinkActivated: Qt.openUrlExternally(link)
        opacity: infocontainer.opacity
        width: 355
    }

    Rectangle { // edit box
        id: editbox
        z: 0
        x: 0
        y: 45
        width: 373
        height: childrenRect.height + 3
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        NewButton {
            anchors.left: parent.left
            anchors.leftMargin: 5
            y: 3
            id: left
            useimg: false
            text: "<<"
            onClicked: { topbar.moveleftClicked() }
        }
        NewButton {
            anchors.right: parent.right
            anchors.rightMargin: 5
            y: 3
            id: right
            useimg: false
            text: ">>"
            onClicked: { topbar.moverightClicked() }
        }
        Row {
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: 3
            y: 3
            Row {
                spacing: 1
                anchors.verticalCenter: parent.verticalCenter;
                Rectangle {
                    id: timeoutInputContainer
                    width: 50; height: 30;
                    color: "white"
                    border.color: "#cbcbcb"
                    border.width: 1
                    anchors.verticalCenter: parent.verticalCenter;
                    radius: 5
                    TextInput {
                        x: 5
                        y: 2
                        font.pointSize: 15
                        id: timeoutInput
                        text: searchModel.timeout
                        width: parent.width - 10
                        height: parent.height - 4
                    }
                }
                NewButton {
                    id: setrefrate
                    bsource: "images/yes.png"
                    anchors.verticalCenter: parent.verticalCenter;
                    onClicked: {
                        searchModel.timeout = parseInt(timeoutInput.text)
                        root.timeoutInSeconds = parseInt(timeoutInput.text)
                        infotext = root.getColumnText()
                    }
                }
            }
            NewButton {
                useimg: false
                usecheckbox: true
                checked: (searchModel.notify == 1)?true:false
                text: "Notify"
                id: notifyToggle
                anchors.verticalCenter: parent.verticalCenter;
                onClicked: {
                    if (searchModel.notify == 1) {
                        searchModel.notify = 0;
                        root.notifyable = 0;
                        checked = false
                        topbar.infotext = root.getColumnText()
                    } else {
                        searchModel.notify = 1;
                        root.notifyable = 1;
                        checked = true
                        topbar.infotext = root.getColumnText()
                    }
                }
            }
        }
    }

    states: [
        State {
            name: "open"

            PropertyChanges {
                target: topbar
                height: (100 > info.height + 55) ? 100 : info.height + 55
            }
            PropertyChanges {
                target: infocontainer
                opacity: 1
            }
        },
        State {
            name: "loading"
            PropertyChanges {
                target: topbar
                height: 100
            }
            PropertyChanges {
                target: refreshing
                opacity: 1
            }
            PropertyChanges {
                target:  infocontainer
                opacity: 0
            }
        },
        State {
            name: "edit"
            PropertyChanges {
                target: topbar
                height: editbox.height + 45
            }
            PropertyChanges {
                target: editbox
                opacity: 1
            }
        },
        State {
            name: "apioverload"
            PropertyChanges { target: hd; color: "grey" }
        }

    ]
}
