import QtQuick 1.0

Item {
    property bool fullscreen: false
    id:testr
    x: 0
    z: 100
    anchors.bottom: parent.bottom
    width: parent.width
    Rectangle {
        id: fullscreenbutton
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 6
        anchors.rightMargin: 8
        width: 54
        height: 54
        radius: 5
        color: "transparent"
        opacity: 0.7
        Image {

            anchors.centerIn: parent
            source: "images/general_fullsize.png"
        }
    }
    MouseArea {
        anchors.fill: fullscreenbutton
        onClicked: {
            if (testr.fullscreen) {
                testr.fullscreen = false
                View.showNormal();
            } else {
                testr.fullscreen = true
                View.showFullScreen();
            }
        }
        onPressed: {
            fullscreenbutton.color = "lightgrey"
        }
        onReleased:  {
            fullscreenbutton.color = "transparent"
        }
    }
}
