#ifndef NOTTY_H
#define NOTTY_H

#include <QObject>
#include <QString>
#include <QDebug>

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
#include <QtDBus/QtDBus>
#include <QDialog>
#include <QtMaemo5/QMaemo5InformationBox>
#include <QList>
#include "qmaemo5extra/qmaemo5notification.h"
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include "qmaemo5extra/maemo5deviceevents.h"

#define APP_DBUS_PATH "/net/mece/tweedsuit"
#define APP_DBUS_SERVICE "net.mece.tweedsuit"
#define APP_DBUS_INTERFACE "net.mece.tweedsuit"

#else
#if !defined(Q_WS_WIN)
#undef signals // Collides with GTK symbols
#include <libnotify/notify.h>
#endif
#endif
class Notty : public QObject
{
    Q_OBJECT

public:
    Notty(QObject *parent = 0) : QObject(parent) {
#if defined(Q_WS_MAEMO_5)
            // vibrate
        interface  = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                                MCE_REQUEST_IF, QDBusConnection::systemBus(),
                                                0);
/*        QDBusMessage reply = interface->call(MCE_ENABLE_VIBRATOR);
        if (reply.type() == QDBusMessage::ErrorMessage)
                qDebug() << reply.errorMessage(); */
#endif
    }
    ~Notty() {
#if defined(Q_WS_MAEMO_5)
        QDBusMessage reply;

        reply = interface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternChatAndEmail");
        if (reply.type() == QDBusMessage::ErrorMessage)
            qDebug() << reply.errorMessage();

/*        reply = interface->call(MCE_DISABLE_VIBRATOR);
        if (reply.type() == QDBusMessage::ErrorMessage)
            qDebug() << reply.errorMessage(); */


#endif
    }

    Q_INVOKABLE void notify(const QString &title, const QString &text) {
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
        QDBusConnection::sessionBus().registerService(APP_DBUS_SERVICE);
        QDBusConnection::sessionBus().registerObject(APP_DBUS_PATH, this, QDBusConnection::ExportScriptableSlots);
        QDBusMessage *dbusMessage = new QDBusMessage(QDBusMessage::createMethodCall(APP_DBUS_SERVICE, APP_DBUS_PATH, APP_DBUS_INTERFACE, "activate_application"));

        QList<StringPair> notificationHints;
        notificationHints.append(StringPair("led-pattern", "PatternCommunicationEmail"));
        Maemo5DeviceEvents e;
        if (QApplication::focusWidget() != NULL && !e.isScreenLocked())
            QMaemo5InformationBox::information(0, text, QMaemo5InformationBox::DefaultTimeout);
        else {
            QMaemo5Notification::nonExpiringInformation(text, title, dbusMessage, notificationHints, "tweedsuit_icon");

#if defined(Q_WS_MAEMO_5)
            QDBusMessage reply = interface->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternChatAndEmail");
            if (reply.type() == QDBusMessage::ErrorMessage)
                qDebug() << reply.errorMessage();
#endif
        }
#else
#if !defined(Q_WS_WIN)
        NotifyNotification *notifi;
        notifi = notify_notification_new(title.toLatin1().data(), text.toLatin1().data(), NULL, NULL);
        if (notifi) {
            notify_notification_set_timeout(notifi, 2200);
            if (!notify_notification_show(notifi, NULL))
                        qDebug("Failed to send notification");
            g_object_unref(notifi);

        } else {
            qDebug("there was a problem with notification init");
        }
#endif
#endif
    }
private:
#if defined(Q_WS_MAEMO_5)
    QDBusInterface *interface;
#endif
};

#endif // NOTTY_H
