#! /usr/bin/python
# -*- coding: utf-8 -*-
# Mikael Honkala

import urllib, urllib2
import base64
from xml.dom import minidom
import os
import sys
import time, calendar
import stat
import gtk, hildon
#from threading import Thread, Timer
import pickle
import subprocess, shlex
import gobject
import feedparser

gtk.gdk.threads_init()

# Tätä voi muuttaa, jos kaipaa muuta kuin täyttä laatua. Kts. formaatit TVKaista sivuilta osoitteesta http://alpha.tvkaista.fi/Info?page=RSS
format = 'ts'
videoformat = 'video/mp4'
videobitrate = '300'
subtitleformat = 'application/x-srt'

# Haetun tiedoston loppuun lisättävä liite - .mpg on paremmin tunnistettava kuin .ts
# Jos et halua lisäliitettä, voit muuttaa tyhjäksi
#additionalExtension = '.mpg'
additionalExtension = ''

# TVKaista säilyttää ohjelmat 4 viikkoa - voisi olla konfiguroitava
weeks_to_retain_shows = 4
seconds_in_a_week = 7 * 24 * 60 * 60
duration_for_retaining_shows = weeks_to_retain_shows * seconds_in_a_week

# Ladattavat tiedostot talletetaan oletusarvoisesti samaan hakemistoon missä tämä .py tiedosto on. Tähän voi laittaa vaihtoehtoisen polun.
saveDirectory = './'
configDirectory = os.path.expanduser("~/MyDocs/.tvkaista-fetch/")
logDirectory = configDirectory + 'Log/'
infoDirectory = configDirectory + 'Info/'

# Näitä voi säätää, jos feedit taas muuttuvat
server = 'http://alpha.tvkaista.fi/feed'
suosikit = '/playlist'
sarjat = '/seasonpasses'
haku = '/search/title/'

# Ei säädettävää tästä eteenpäin
username = ''
password = ''
feeds = []
config = None
selected = []
searches = []
favorites = []
seasonpasses = []
win = None
selector = None
videodir = ""

ALL = 0
NEW = 1
LOADED = 2
display_filter = ALL

# Hakufunktio feedeille, hoitaa autentikoinnin

def getUrl(url):
  global config
  username, password = config['auth']
  return getUrlWithAuth(url, username, password)

def getUrlWithAuth(url, testusername, testpassword) :
  req = urllib2.Request(url);
  base64string = base64.encodestring('%s:%s' % (testusername, testpassword))[:-1]
  authheader =  "Basic %s" % base64string
  req.add_header("Authorization", authheader)
  return urllib2.urlopen(req)

def sync_status(message):
  hildon.hildon_banner_show_information(win, "", message)
  while gtk.events_pending() :
    gtk.main_iteration(False)

def get_and_clean_show_info(mark_as_old = True) :
  fetchFiles = []
  nowtime = time.time()
  dirlists = os.walk(infoDirectory)
  for dirlist in dirlists :
    dirpath, dirnames, filenames = dirlist
    if dirpath == infoDirectory :
      for filename in filenames :
        infoPack = info_from_file(filename)
        (timestamp, titlestr, descriptionstr, videourl, subtitleurl, filename, subfilename, size) = infoPack
        # Remove old show information, if not downloaded
        if not os.path.exists(saveDirectory + filename) :
          showtime = time.mktime(timestamp)
          if (nowtime - showtime) > duration_for_retaining_shows :
            os.remove(infoDirectory + filename)
            if os.path.exists(logDirectory + filename) :
              os.remove(logDirectory + filename)
            continue
        fetchFiles.append(infoPack)
        # Mark all remaining shows as old
        if mark_as_old and (not os.path.exists(logDirectory + filename)) :
          logfile = open(logDirectory + filename, "w")
          logfile.close()
  fetchFiles.sort()
  fetchFiles.reverse()
  return fetchFiles

def fetch_show_info(display_area) :
  global config, feeds, favorites, seasonpasses

  fetchFiles = feeds

  baseFeeds = []
  favorites = []
  seasonpasses = []

  sync_status("Päivitetään ohjelmatiedot")

  # Suosikkilista haetaan ainakin
  baseFeeds.append(server + suosikit)

  # Haetaan avainsanahaut, jos niitä on
  if 'searches' in config :
    for search in config['searches'] :
      baseFeeds.append(server + haku + urllib.quote(search))

  sync_status("Haetaan sarjalista")

  # Haetaan sarjakohtaiset syötteet
  rss = minidom.parse(getUrl(server + sarjat))
  for node in rss.getElementsByTagName('item') :
    baseFeeds.append(node.getElementsByTagName('link')[0].firstChild.data)
    seasonpasses.append(node.getElementsByTagName('title')[0].firstChild.data)
  config['seasonpasses'] = seasonpasses
  config_to_file(config)

  sync_status("Haetaan ohjelmakohtaiset tiedot")

  print baseFeeds

  # Sitten haetaan kaikista feedeistä ohjelmakohtaiset Urlit
  for feed in baseFeeds:
    print "1"
    getting_favorites = False
    if feed == (server + suosikit) :
      getting_favorites = True
    try :
      print "2"
      rss = minidom.parse(getUrl(feed + '/' + format + '.mediarss'))
      prev_title = ""
      for node in rss.getElementsByTagName('item') :
        print "3"
        timestampstr = node.getElementsByTagName('pubDate')[0].firstChild.data
        timetuple = feedparser._parse_date(timestampstr)
        gmtime = calendar.timegm(timetuple)
        timestamp = time.localtime(gmtime)
        mediaelem = node.getElementsByTagName('media:group')
        if not mediaelem : continue
        media = mediaelem[0]
        titlestr = media.getElementsByTagName('media:title')[0].firstChild.data
        if titlestr != prev_title :
          if getting_favorites :
            favorites.append(titlestr)
            config['favorites'] = favorites
            config_to_file(config)
          sync_status("Haetaan tiedot: " + titlestr)
        print "4"
        prev_title = titlestr
        descriptionstr = "Ohjelmasta ei saatavilla kuvausta"
        mediaElement = media.getElementsByTagName('media:description')
        if mediaElement :
          descriptionstr = mediaElement[0].firstChild.data
        videourl = None
        subtitleurl = None
        print "5"
        for content in media.getElementsByTagName('media:content') :
          mediatype = content.getAttribute('type')
          if mediatype == videoformat :
            if content.getAttribute('bitrate') == videobitrate :
              videourl = content.getAttribute('url')
              size = content.getAttribute('fileSize')
          if mediatype == subtitleformat :
            subtitleurl = content.getAttribute('url')
        if videourl :
          urlObject = getUrl(videourl)
          redirectedUrl = urlObject.geturl()
          filename = urlObject.geturl().split('outputfilename=')[1]
          urlObject.close()
          subfilename = None
          if subtitleurl :
            try :
              urlObject = getUrl(subtitleurl)
              redirectedUrl = urlObject.geturl()
              subfilename = urlObject.geturl().split('outputfilename=')[1]
              urlObject.close()
            except Exception, e :
              sync_status("Tekstitystiedostovirhe: " + str(e))
              print sys.exc_info()
            if not subfilename :
              subfilename = "error"
#          logFilename = logDirectory + filename
          if not os.path.exists(logDirectory) :
            os.makedirs(logDirectory)
          infoPack = (timestamp, titlestr, descriptionstr, videourl, subtitleurl, filename, subfilename, size)
          if not os.path.exists(infoDirectory + filename) :
            info_to_file(infoPack, filename)
            feeds.append(infoPack)
            feeds.sort()
            feeds.reverse()
            create_selector(display_area)
            gtk.main_iteration()
    except Exception, e :
      sync_status("Latausvirhe: " + str(e))
      print sys.exc_info()
  config['favorites'] = favorites
  config_to_file(config)
  return fetchFiles

cancel = False

def download_files(widget, display_area) :
  global selected, feeds, win, videodir, cancel
  blocksize = 1000000
  if len(selected) > 0 :
    for index, row_selected in enumerate(selected) :
      if row_selected :
        downloadsize = 0
        timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
        partialSaveFilename = videodir + filename + '.partial'
        try :
          pbar = gtk.ProgressBar()
          pbar.set_fraction(0.0)
          dialog = gtk.Dialog("Ladataan " + name, win)
          dialog.vbox.add(pbar)
          cancelbutton = create_button("  Lopeta  ", None, None, cancel_load)
          dialog.action_area.add(cancelbutton)
#          note = hildon.Note("cancel", win, "Ladataan " + name, progressbar=pbar)
          dialog.show_all()
          while gtk.events_pending() :
            gtk.main_iteration()
          urlObject = getUrl(vurl)
          saveFilename = videodir + filename + additionalExtension
          savefile = open(partialSaveFilename, "w")
          while True :
            block = urlObject.read(blocksize)
            if block == '':
              break
            savefile.write(block)
            downloadsize += blocksize
            pbar.set_fraction(min(float(downloadsize)/float(size), 1.0))
            while gtk.events_pending() :
              gtk.main_iteration()
            if cancel :
              cancel = False
              dialog.destroy()
              savefile.close()
              if os.path.exists(partialSaveFilename) :
                os.remove(partialSaveFilename)
              return
            time.sleep(0.2)
          savefile.close()
          dialog.destroy()
          os.rename(partialSaveFilename, saveFilename)
          os.chmod(saveFilename, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH)
          if surl and not (subfilename == "error") :
            urlObject = getUrl(surl)
            partialSaveFilename = videodir + subfilename + '.partial'
            saveFilename = videodir + subfilename
            savefile = open(partialSaveFilename, "w")
            savefile.write(urlObject.read(blocksize))
            savefile.close()
            os.rename(partialSaveFilename, saveFilename)
            os.chmod(saveFilename, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH)
          # Log successful download
          logfile = open(logDirectory + filename, "w")
          logfile.close()
        except urllib2.HTTPError, e :
          sync_status("Latausvirhe: " + str(e))
    create_selector(display_area)

def cancel_load(widget) :
  global cancel
  cancel = True

def watch_it(widget, index) :
  global feeds
  timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
  if not os.path.exists(videodir + filename) :
    sync_status("Valittua ohjelmaa ei ole ladattu")
  else :
    command_template = 'dbus-send --print-reply --dest=com.nokia.mediaplayer /com/nokia/mediaplayer com.nokia.mediaplayer.mime_open string:"file:///%s"'
    command = command_template % (videodir + filename)
    args = shlex.split(command)
    subprocess.Popen(args)

def do_refresh(widget, display_area) :
  global win, feeds, config
  feeds = get_and_clean_show_info() # From local files
  feeds = fetch_show_info(display_area) # From TVKaista

def add_to(table, widget, row, column, width_options=None) :
  xopt = gtk.FILL|gtk.EXPAND
  if width_options :
    xopt = width_options
  table.attach(widget, row, row+1, column, column+1, xoptions=xopt)

def create_selector(display_area) :
  global feeds, selected, selector, win, display_filter
  alloc = win.get_allocation()
  if selector : selector.destroy()
  if len(feeds) > 0 :
    table = gtk.Table(len(feeds), 3)
    table.set_size_request(alloc.width, -1)
  selected = []
  index = -1
  visible = 0
  for infoPack in feeds :
    (timestamp, name, descr, vurl, surl, filename, subfilename, size) = infoPack
    index += 1
#    selected.append(not os.path.exists(logDirectory + filename))
    selected.append(False)
    if display_filter == NEW and os.path.exists(logDirectory + filename) :
      continue
    if display_filter == LOADED and not os.path.exists(videodir + filename) :
      continue
    visible += 1
    icon_name = ""
    if selected[index] :
      icon_name = "clock_alarm_on"
    else :
      icon_name = "clock_alarm_off"
    togglebutton = create_button("", None, icon_name, toggle_selected, index)
    togglebutton.set_relief(gtk.RELIEF_NONE)
    add_to(table, togglebutton, 0, index)
    timestr = time.strftime("%d.%m.", timestamp)
    displaystr = "%s - %s" % (timestr, name)
    button = create_button(displaystr, descr, None, create_info_window, infoPack)
    button.set_relief(gtk.RELIEF_NONE)
    button.set_alignment(0, 0, 0, 0)
    add_to(table, button, 1, index, gtk.FILL|gtk.SHRINK)
    if os.path.exists(videodir + filename) :
      button = create_button("", None, 'camera_playback', watch_it, index)
      button.set_relief(gtk.RELIEF_NONE)
      add_to(table, button, 2, index)
    elif not os.path.exists(logDirectory + filename) :
      image = gtk.Image()
      image.set_from_icon_name('imageviewer_favourite', gtk.ICON_SIZE_BUTTON)
      add_to(table, image, 2, index)
  if visible > 4 :
    selector = hildon.PannableArea()
    selector.add_with_viewport(table)
    display_area.pack_start(selector, True, True)
  elif visible > 0 :
    selector = table
    display_area.pack_start(selector, False, False)
  else :
    if display_filter == ALL :
      selector = gtk.Label("Ei ohjelmatietoja")
    elif display_filter == NEW :
      selector = gtk.Label("Ei uusia ohjelmia")
    else :
      selector = gtk.Label("Ei ladattuja ohjelmia")
    display_area.add(selector)
  display_area.show_all()

def toggle_selected(widget, index) :
  global selected
  image = gtk.Image()
  icon_name = ""
  if selected[index] :
    selected[index] = False
    icon_name = "clock_alarm_off"
  else :
    selected[index] = True
    icon_name = "clock_alarm_on"
  image.set_from_icon_name(icon_name, gtk.ICON_SIZE_BUTTON)
  widget.set_image(image)

#def toggle_proxy(widget, button) :
#  button.clicked()

def create_info_window(widget, infoPack) :
  (timestamp, name, descr, vurl, surl, filename, subfilename, size) = infoPack
  info_window = hildon.StackableWindow()
  info_window.set_title(name)
  info_window.show_all()
  gtk.main_iteration()
  alloc = info_window.get_allocation()
#  table = gtk.Table(len(feeds), 3)
#  table.set_size_request(alloc.width, -1)
  content = gtk.VBox(False, 10)
  namelabel = gtk.Label()
  namelabel.set_alignment(0, 0.0)
  namelabel.set_markup('<b>%s</b>' % name)
  numberslabel = gtk.Label()
  timestr = time.strftime("%c", timestamp) # "%A %d.%m.%y klo %h:M"
  sizemb = int(size) / (1024 * 1024)
  numberslabel.set_markup('<i>%s - %d Mb</i>' % (timestr, sizemb))
  numberslabel.set_alignment(0, 0.0)
  descrlabel = gtk.Label(descr)
  descrlabel.set_line_wrap(True)
  descrlabel.set_size_request(alloc.width, -1)
  descrlabel.set_alignment(0, 0.0)
  status = ''
  if not os.path.exists(logDirectory + filename) :
    status += "Tämä ohjelma on ollut uusi viimeisessä päivityksessä. "
  if not os.path.exists(videodir + filename) :
    status += "Ohjelman tiedostoja ei ole ladattuna tällä laitteella. "
  else:
    status += "Ohjelman tiedostot on ladattu ja valmiina katsottavaksi. "
  if surl :
    if subfilename == "error" :
      status += "Ohjelmassa ei ole tekstitystä, koska tekstitystiedostoa ei löytynyt palvelimelta. "
    else :
      status += "Ohjelman tekstitys on erillisessä tiedostossa. Tekstityksen näkyminen vaatii Subtitles Support -paketin asennuksen ja käytön Unicode (UTF-8) -asetuksella. "
  statuslabel = gtk.Label()
  statuslabel.set_markup('<i>%s</i>' % status)
  statuslabel.set_line_wrap(True)
  statuslabel.set_size_request(alloc.width, -1)
  statuslabel.set_alignment(0, 0.0)
  content.pack_start(namelabel, False, False)
  content.pack_start(numberslabel, False, False)
  content.pack_start(descrlabel, False, False)
  content.pack_start(gtk.HSeparator(), False, False)
  content.pack_start(statuslabel, False, False)
#  content.add(descrlabel)
  info_window.add(content)
  content.show_all()

def delete_files(widget, display_area) :
  global selected, feeds, videodir
  if len(selected) > 0 :
    count = 0
    for index, row_selected in enumerate(selected) :
      if row_selected :
        timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
        videofile = videodir + filename
        if os.path.exists(videofile) :
          os.remove(videofile)
          count += 1
        if os.path.exists(videofile + '.partial') :
          os.remove(videofile + '.partial')
          count += 1
        if subfilename :
          subfile = videodir + subfilename
          if os.path.exists(subfile) :
            os.remove(subfile)
            count += 1
          if os.path.exists(subfile + '.partial') :
            os.remove(subfile + '.partial')
            count += 1
    if count == 0 :
      sync_status("Ei poistettavia tiedostoja valittuna")
    else :
      sync_status("Tiedostoja poistettu: %s" % str(count))
    create_selector(display_area)

#def log_as_old(widget, display_area) :
#  global selected, feeds
#  if len(selected) > 0 :
#    for index, row_selected in enumerate(selected) :
#      if row_selected :
#        timestamp, name, descr, vurl, surl, filename, subfilename, size = feeds[index]
#        logFilename = logDirectory + filename
#        logfile = open(logFilename, "w")
#        logfile.close()
#    create_selector(display_area)

def show_search_window(widget, data=None) :
  global config, favorites, seasonpasses
  search_window = hildon.StackableWindow()
  search_window.set_title("Ohjelmien hakuehdot")
  columns = gtk.HBox()
  topservercolumn = gtk.VBox()
  topservercolumn.pack_start(create_label("<b>Palvelimella</b>"), False, False)
  topservercolumn.pack_start(create_label(" "), False, False)
  area = hildon.PannableArea()
  servercolumn = gtk.VBox()
  area.add_with_viewport(servercolumn)
  topservercolumn.add(area)
  favoritesheadingtext = "<i>Katselulista:</i>"
  if len(favorites) == 0 :
    favoritesheadingtext = "<i>Ei mitään katselulistalla</i>"
  servercolumn.pack_start(create_label(favoritesheadingtext), False, False)
  for favoritestr in favorites :
    servercolumn.pack_start(create_label(favoritestr), False, False)
  servercolumn.pack_start(create_label(" "), False, False)
  seasonpassheadingtext = "<i>Sarjat:</i>"
  if len(seasonpasses) == 0 :
    seasonpassheadingtext = "<i>Ei sarjoja valittuna</i>"
  servercolumn.pack_start(create_label(seasonpassheadingtext), False, False)
  for seasonpassstr in seasonpasses :
    servercolumn.pack_start(create_label(seasonpassstr), False, False)
  localcolumn = gtk.VBox()
  localcolumn.pack_start(create_label("<b>Paikalliset</b>"), False, False)
  larea = hildon.PannableArea()
  search_list = gtk.VBox()
  larea.add_with_viewport(search_list)
  if 'searches' in config :
    for search in config['searches'] :
      button = create_button(search, None, None, remove_search, (search, larea, search_list))
      button.set_relief(gtk.RELIEF_NONE)
      button.set_alignment(0, 0.5, 0, 0)
      search_list.pack_start(button, False, False)
  entry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
##  caption = hildon.Caption(None, "Haku", entry, None, True)
  add_button = create_button("Lisää", "vapaa haku", "general_add", add_search, (entry, search_list, larea))
  entry.connect('activate', add_search, (entry, search_list, larea))
  add_box = gtk.HBox()
  add_box.add(entry)
  add_box.pack_end(add_button, False, False)
  label = create_label("<i>Valitse rivi poistaaksesi sen</i>")
  localcolumn.add(larea)
  localcolumn.pack_start(add_box, False, False)
  localcolumn.pack_end(label, False, False)
  columns.add(topservercolumn)
  columns.pack_start(gtk.VSeparator(), False, False)
  columns.add(localcolumn)
  search_window.add(columns)
  search_window.show_all()
  entry.grab_focus()

def add_search(widget, data) :
  global config
  entry, search_list, larea = data
  searches = []
  value = entry.get_text()
  if 'searches' in config :
    searches = config['searches']
  if value != '' :
    if value in searches :
      sync_status("Haku jo listalla")
      return
    searches.append(value)
    config['searches'] = searches
    config_to_file(config)
    button = create_button(value, None, None, remove_search, (value, larea, search_list))
    button.set_relief(gtk.RELIEF_NONE)
    button.set_alignment(0, 0.5, 0, 0)
    button.connect("size_allocate", scroll_to_button, larea)
    search_list.pack_start(button, False, False)
    button.show()
    entry.set_text("")

def scroll_to_button(widget, event, larea) :
  alloc = widget.get_allocation()
  larea.scroll_to(-1, alloc.y + int(alloc.height/2))

def remove_search(widget, data) :
  global config
  search, larea, search_list = data
  alloc = widget.get_allocation()
  searches = []
  if 'searches' in config :
    searches = config['searches']
  searches.remove(search)
  config['searches'] = searches
  config_to_file(config)
  search_list.remove(widget)
  larea.scroll_to(-1, alloc.y)

def show_auth_dialog(widget) :
  global win
  dialog = gtk.Dialog("TVKaistan käyttöoikeus - nykyistä ei näytetä", win)
  dialog.set_transient_for(win)
  uentry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
#  uentry.set_text(username)
  pentry = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
#  pentry.set_text(password)
  group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
  ucaption = hildon.Caption(group, "Tunnus", uentry, None, True)
  pcaption = hildon.Caption(group, "Salasana", pentry, None, True)
  dialog.vbox.add(ucaption)
  dialog.vbox.add(pcaption)
#  test_button = create_button("Testaa", "yhteys", None, test_connection, (uentry, pentry))
  save_button = create_button("Tallenna", None, None, save_auth, (dialog, uentry, pentry))
#  uentry.connect("activate", click_button, button)
#  dialog.action_area.add(test_button)
  dialog.action_area.add(save_button)
  dialog.show_all()

def save_auth(widget, entries) :
  global config
  dialog, uentry, pentry = entries
  sync_status("Testataan yhteys")
  try :
    getUrlWithAuth(server, uentry.get_text(), pentry.get_text())
    sync_status("Yhteys ok")
    config = {}
    config['auth'] = ( uentry.get_text(), pentry.get_text())
    config_to_file(config)
    dialog.destroy()
  except urllib2.HTTPError, error :
    if error.code == 401 :
      sync_status("Tunnus/salasana ei kelpaa")
    else:
      sync_status(str(error))

def show_dir_dialog(widget, display_area) :
  global win, config, videodir
  fc = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
#  fc.set_property('show-files',True)
  fc.set_current_folder(videodir)
  if fc.run() == gtk.RESPONSE_OK :
    videodir = fc.get_filename() + "/"
    config["videodir"] = videodir
    config_to_file(config)
  fc.destroy()
  create_selector(display_area)

#  fsm = hildon.FileSystemModel(win, '/')
#  fsm.load_path(videodir)
#  dialog = hildon.FileChooserDialog(win, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, fsm)
#  dialog = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
#  dialog.set_transient_for(win)
#  dialog.connect("button_press_event", save_dir)
#  dialog.set_filename(videodir)
#  dialog.show_all()
#  response = dialog.run()
#  if response == gtk.RESPONSE_OK :
#    videodir = dialog.get_filename() + "/"
#    config["videodir"] = videodir
#    config_to_file(config)
#    dialog.destroy()
#    create_selector(display_area)

def create_button(title, value, stock_icon, function, *args) :
  button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, title)
  if value :
    button.set_value(value)
  if stock_icon :
    image = gtk.Image()
    if isinstance(stock_icon, str) :
      image.set_from_icon_name(stock_icon, gtk.ICON_SIZE_BUTTON)
    else :
      image.set_from_stock(stock_icon, gtk.ICON_SIZE_BUTTON)
    button.set_image(image)
  if function :
    button.connect("clicked", function, *args)
  return button

def create_label(text=None, markup=True, leftalign=True) :
 label = gtk.Label()
 if leftalign :
   label.set_alignment(0, 0)
 if label :
   if markup :
     label.set_markup(text)
   else :
     label.set_text(text)
 return label

def config_to_file(obj) :
  if not os.path.exists(configDirectory) :
    os.makedirs(configDirectory)
  savefile = open(configDirectory + 'TVKaista.cfg', "w")
  pickle.Pickler(savefile, pickle.HIGHEST_PROTOCOL).dump(obj)
  savefile.close()

def config_from_file() :
  try :
    loadfile = open(configDirectory + 'TVKaista.cfg', "r")
    return pickle.Unpickler(loadfile).load()
  except :
    return None
#  finally :
#    loadfile.close()

def info_to_file(infoPack, filename) :
  if not os.path.exists(infoDirectory) :
    os.makedirs(infoDirectory)
  savefile = open(infoDirectory + filename, "w")
  pickle.Pickler(savefile, pickle.HIGHEST_PROTOCOL).dump(infoPack)
  savefile.close()

def info_from_file(filename) :
  try :
    loadfile = open(infoDirectory + filename, "r")
    return pickle.Unpickler(loadfile).load()
  except :
    return None
#  finally :
#    loadfile.close()

def set_display_filter(widget, data):
  global display_filter
  display_filter, display_area = data
  config['display_filter'] = display_filter
  config_to_file(config)
  create_selector(display_area)

def main():
  global win, black_pixbuf, config, feeds, videodir, display_filter, favorites, seasonpasses
  win = hildon.StackableWindow()
  win.set_title("TVKaistan noutaja")
  config = config_from_file()
  if config == None :
    config = dict()
    show_auth_dialog(None)
  if 'videodir' in config :
    videodir = config['videodir']
  else :
    videodir = os.path.expanduser("~/MyDocs/.videos/")
    config['videodir'] = videodir
  if 'display_filter' in config :
    display_filter = config['display_filter']
  if 'favorites' in config :
    favorites = config['favorites']
  if 'seasonpasses' in config :
    seasonpasses = config['seasonpasses']
  config_to_file(config)
  column = gtk.VBox()
  top_buttons = gtk.HBox()
  check_new_button = create_button("Päivitä", "ohjelmatiedot palvelusta", "general_refresh", do_refresh, column)
  edit_search_button = create_button("Haut", None, "general_search", show_search_window, None)
  top_buttons.add(check_new_button)
  top_buttons.add(edit_search_button)
  column.pack_start(top_buttons, False, False)
  column.pack_start(gtk.HSeparator(), False, False)
#  column.add(pannable)
  buttons = gtk.HBox()
  download_button = create_button("Lataa", "valitut", "keyboard_move_down", download_files, column)
#  mark_old_button = create_button("Merkitse", "vanhoiksi", "general_presence_offline", log_as_old, column)
  delete_button = create_button("Poista", "valittujen ladatut tiedostot", "camera_delete", delete_files, column)
#  play_button = create_button("Katso", "valittu", gtk.STOCK_MEDIA_PLAY, watch_it, column)
#  buttons.add(mark_old_button)
  buttons.add(delete_button)
#  buttons.add(play_button)
  buttons.add(download_button)
  column.pack_end(buttons, False, False)
  column.pack_end(gtk.HSeparator(), False, False)
  menu = hildon.AppMenu()
  filter1 = gtk.RadioButton(None, "Kaikki")
  filter1.set_mode(False)
  filter1.connect("clicked", set_display_filter, (ALL, column))
  menu.add_filter(filter1)
  filter2 = gtk.RadioButton(filter1, "Uudet")
  filter2.set_mode(False)
  filter2.connect("clicked", set_display_filter, (NEW, column))
  menu.add_filter(filter2)
  filter3 = gtk.RadioButton(filter1, "Ladatut")
  filter3.set_mode(False)
  filter3.connect("clicked", set_display_filter, (LOADED, column))
  menu.add_filter(filter3)
  m_auth = gtk.Button("Käyttöoikeus")
  m_auth.connect("clicked", show_auth_dialog)
  menu.append(m_auth)
  m_dir = gtk.Button("Talletushakemisto")
  m_dir.connect("clicked", show_dir_dialog, column)
  menu.append(m_dir)
#  m_search = gtk.Button("Haut")
#  m_search.connect("clicked", show_search_window)
#  menu.append(m_search)
  menu.show_all()
  win.set_app_menu(menu)
  win.add(column)
  win.connect("destroy", gtk.main_quit, None)
  win.show_all()
  gtk.main_iteration()
  feeds = get_and_clean_show_info(False)
  if len(feeds) > 0 :
    create_selector(column)
  filters = [ filter1, filter2, filter3 ]
  filter_state = filters[display_filter]
  filter_state.clicked()
#  Timer(0.1, fetch_show_info).start()

if __name__ == "__main__":
  main()
  gtk.main()