#!/bin/sh
dldir=/var/tmp
catchupdir=/home/user/.tvcplayer
wgetopts="-T10 -q"


note()
{
/usr/bin/dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"$1"
echo $1
}

geturl()
{
urlline=`expr 4 + $1 \* 2`
url0=`head -$urlline url | tail -1`
if [[ "`echo $url0 | cut -c1-4`" != "http" ]]
	then                
	url=$urlbase/$url0
	else
	url=$url0
fi
}

dl0()
{
nice wget $wgetopts $url -O tmp.ts
bytes=`wc -c < tmp.ts`
echo "$count: Downloaded $bytes bytes"
if [ "$bytes" == "0" ]
                        then
                        echo $url
                        echo Retrying
else
                        mv tmp.ts tmp$count.ts
                        count=`expr $count + 1`
fi
}


download()
{
rm 2>/dev/null tmp*.ts
nice wget $wgetopts `tail -1 $dldir/playlist.m3u8` -O url
count=0

geturl 1
dl0

geturl 2
dl0

geturl 3
dl0

while [ 1 ]
        do
        nice wget $wgetopts `tail -1 $dldir/playlist.m3u8` -O url
        urlold=$url
	geturl 3
        if [[ "$url" == "$urlold" ]] 
                then
                sleep 1
        else
		dl0
        fi
        sleep 1
done
}

play()
{
playcount=0
while [ 1 ]
        do
        while [ ! -e "tmp`expr $playcount + 0`.ts" ]
                do
                sleep 1
                done
        cat tmp$playcount.ts 
        rm tmp$playcount.ts
        playcount=`expr $playcount + 1`
        done
}

doexit(){
echo Exiting
echo Killing $dlpid $plpid
kill 2>/dev/null $dlpid $plpid
cd $catchupdir
""rm -r $catchupdir/tmp$thispid
trap - 0 1 2 15
stty echo
}

thisdir=`pwd`
mkdir 2>/dev/null $catchupdir
cd $catchupdir
channel=$1
if [ "$1" == "" ]
	then
	cat /opt/tvcplayer/channels
	echo Select channel:
	read channel
fi
if [ ! -e username ] 
	then
	echo -n "Username: "
	read username
	echo >username $username
	fi	
if [ ! -e password ]
	then 
	echo -n "Password: "
	stty -echo
	read password
	stty echo
	echo
	echo >password $password
	fi
username=`cat username`
password=`cat password`

if [ ! -e mplayeropts ]
	then
	cp /opt/tvcplayer/mplayeropts mplayeropts
fi
mplayeropts=`cat mplayeropts`

thispid=$$
mkdir tmp$thispid
cd tmp$thispid
echo Logging in as \"$username\"
wget $wgetopts --keep-session-cookies --save-cookies=cookies --post-data="username=$username&password=$password" "http://iphone.tvcatchup.com/?login=1" -O login.html
if [ "`cat login.html`" == "success" ]
        then
        echo Login OK
        else
        note "Login unsuccesful"
        cd $catchupdir
        ""rm -r $catchupdir/tmp$thispid
        exit
        fi
echo Loading playlist
wget $wgetopts --load-cookies=cookies "http://iphone.tvcatchup.com/?chan=$channel" -O $dldir/playlist.m3u8
if [ "`head -1 $dldir/playlist.m3u8`" != "#EXTM3U" ]
	then
	urlbase=`grep < /var/tmp/playlist.m3u8 videoUrl| cut -d "'" -f2`
	echo Playlist URL: $urlbase
	wget $wgetopts --load-cookies=cookies $urlbase -O $dldir/playlist.m3u8
	fi
if [ "`head -1 $dldir/playlist.m3u8`" != "#EXTM3U" ]
	then
	note "Invalid playlist file"
	echo ==============================================================================
	cat $dldir/playlist.m3u8
	echo
	echo ==============================================================================
	echo Press ENTER or close the terminal window
	read a
        cd $catchupdir
        ""rm -r $catchupdir/tmp$thispid
	exit
	fi
urlbase=`tail -1 $dldir/playlist.m3u8 | cut -d "/" -f 1-5`
note "Playlist file downloaded"

echo Base URL: $urlbase

trap "doexit" 0 1 2
download &
dlpid=$!
renice $dlpid
if [ "$2" == "" ]
	then
	note "Starting mplayer - Please wait!"
	rm 2>/dev/null tvfifo.ts
	mkfifo tvfifo.ts
	play > tvfifo.ts &
	plpid=$!
	renice $plpid
	mplayer $mplayeropts tvfifo.ts
else
	outfile=$2
	if [ "`echo $outfile|cut -c1`" != "/" ]
		then
		outfile=$thisdir/$outfile
		fi
	echo "Recording to $outfile"
	play > $outfile &
	plpid=$!
	if [ "$3" == "" ]
		then
		wait
	else
		rectime=$3
		while [ "$rectime" != "0" ]
			do
			echo $rectime minutes remaining
			sleep 60
			rectime=`expr $rectime - 1`
		done
	fi
fi
doexit

