#!/bin/sh
dldir=/var/tmp
catchupdir=/home/user/.tvcplayer
wgetopts="-T10 -q"


note()
{
/usr/bin/dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"$1"
echo $1
}

geturl()
{
urlline=`expr 4 + $1 \* 2`
url0=`head -$urlline url | tail -1`
if [[ "`echo $url0 | cut -c1-4`" != "http" ]]
	then                
	url=$urlbase/$url0
	else
	url=$url0
fi
}

dl0()
{
nice wget $wgetopts $url -O tmp.ts
bytes=`wc -c < tmp.ts`
echo "$count: Downloaded $bytes bytes"
if [ "$bytes" == "0" ]
                        then
                        echo $url
                        echo Retrying
else
                        mv tmp.ts tmp$count.ts
                        count=`expr $count + 1`
fi
}


download()
{
rm 2>/dev/null tmp*.ts
nice wget $wgetopts `tail -1 $dldir/playlist.m3u8` -O url
count=0

geturl 1
dl0

geturl 2
dl0

geturl 3
dl0

while [ 1 ]
        do
        nice wget $wgetopts `tail -1 $dldir/playlist.m3u8` -O url
        urlold=$url
	geturl 3
        if [[ "$url" == "$urlold" ]] 
                then
                sleep 1
        else
		dl0
        fi
        sleep 1
done
}

play()
{
playcount=0
while [ 1 ]
        do
        while [ ! -e "tmp`expr $playcount + 0`.ts" ]
                do
                sleep 1
                done
        cat tmp$playcount.ts 
        rm tmp$playcount.ts
        playcount=`expr $playcount + 1`
        done
}

doexit(){
echo Exiting
echo Killing $dlpid $plpid
kill 2>/dev/null $dlpid $plpid
cd $catchupdir
""rm 2>/dev/null -r $catchupdir/tmp$thispid
trap - 0 1 2 15
stty echo
}

thisdir=`pwd`
mkdir 2>/dev/null $catchupdir
cd $catchupdir
channel=$1
if [ "$1" == "" ]
	then
	echo " 1 BBC One         2 BBC Two       3 ITV1"
	echo " 4 Channel 4       5 FIVE          6 ITV2"
	echo " 7 Five USA        8 E4            9 ITV3"
	echo "10 ITV4           11 More 4       12 BBC Three"
	echo "13 BBC Four       15 Fiver        16 Film 4"
	echo "17 BBC News       18 CBBC         19 CITV"
	echo "20 Channel 4 +1   21 E4 +1        23 ITV2 +1"
	echo "24 CBeebies       25 4Music       27 More4 +1"
	echo "28 ITV3 +1        29 ITV4 +1      30 Film4 +1"
	echo "31 BBC Parliament"
	echo Select channel:
	read channel
fi
if [ ! -e username ] 
	then
	echo -n "Username: "
	read username
	echo >username $username
	fi	
if [ ! -e password ]
	then 
	echo -n "Password: "
	stty -echo
	read password
	stty echo
	echo
	echo >password $password
	fi
username=`cat username`
password=`cat password`

if [ ! -e mplayeropts ]
	then
	cp /opt/tvcplayer/mplayeropts mplayeropts
fi
mplayeropts=`cat mplayeropts`

thispid=$$
mkdir tmp$thispid
cd tmp$thispid
echo Logging in as \"$username\"
wget $wgetopts --save-cookies=cookies --post-data="username=$username&password=$password" "http://iphone.tvcatchup.com/?login=1" -O login.html
if [ "`cat login.html`" == "success" ]
        then
        echo Login OK
        else
        note "Login unsuccesful"
        exit
        fi
echo Loading playlist
wget $wgetopts --load-cookies=cookies "http://iphone.tvcatchup.com/?chan=$channel" -O $dldir/playlist.m3u8
if [ "`head -1 $dldir/playlist.m3u8`" != "#EXTM3U" ]
	then
	note "Invalid playlist file"
	exit
	fi
note "Playlist file downloaded"
urlbase=`tail -1 $dldir/playlist.m3u8 | cut -d "/" -f 1-5`
echo Base URL: $urlbase

trap "doexit" 0 1 2
download &
dlpid=$!
renice $dlpid
if [ "$2" == "" ]
	then
	note "Starting mplayer - Please wait!"
	rm 2>/dev/null tvfifo.ts
	mkfifo tvfifo.ts
	play > tvfifo.ts &
	plpid=$!
	renice $plpid
	mplayer $mplayeropts tvfifo.ts
else
	outfile=$2
	if [ "`echo $outfile|cut -c1`" != "/" ]
		then
		outfile=$thisdir/$outfile
		fi
	echo "Recording to $outfile"
	play > $outfile &
	plpid=$!
	if [ "$3" == "" ]
		then
		wait
	else
		rectime=$3
		while [ "$rectime" != "0" ]
			do
			echo $rectime minutes remaining
			sleep 60
			rectime=`expr $rectime - 1`
		done
	fi
fi
doexit

