/*
 * Copyright (C) 2016 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.1
import com.nokia.meego 1.0

MySelectionDialog {
    id: root

    property variant value

    onAccepted: if (model) value = model.data(selectedIndex, "value");
    onStatusChanged: {
        if ((status === DialogStatus.Opening) && (model) && (model.count > 0)) {
            selectedIndex = Math.max(0, model.match(0, "value", value));
        }
    }
}
