/*
 * TurnOver - try to turn over all the chess pieces
 * Copyright (C) 2010 Xizhi Zhu
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include "scene.h"
#include "settingdialog.h"

#include <QtGui/QAction>
#include <QtGui/QMainWindow>


class MainWindow: public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private Q_SLOTS:
    void changeSetting(int column, int row);
    void initGame();
    void showAbout();
    void showSetting();
    void showWinner(int clicks);

private:
    void setupAction();
    void setupUi();

    int column;
    int row;
    QAction *aboutAction;
    QAction *restartAction;
    QAction *settingAction;
    Scene *scene;
    SettingDialog *settingDialog;
};


#endif // MAINWINDOW_H
