/*
 * TurnOver - try to turn over all the chess pieces
 * Copyright (C) 2010 Xizhi Zhu
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "scene.h"

#include <QtGui/QGraphicsSceneMouseEvent>


const QColor Scene::BACKGROUND_COLOR = QColor(255, 240, 190);
const QColor Scene::LATTICE_COLOR = QColor(140, 50, 5);


Scene::Scene(QObject *parent)
    : QGraphicsScene(parent), column(0), row(0), clicks(0), seconds(0)
{
    // do nothing
}

Scene::~Scene()
{
    // do nothing
}

void Scene::initBoard(int column, int row)
{
    clear();

    this->column = column;
    this->row = row;
    this->clicks = 0;
    this->seconds = 0;

    int width = LATTICE_SIZE * column;
    int height = LATTICE_SIZE * row;

    // draw the background
    addRect(0, 0, width, height, QPen(BACKGROUND_COLOR), QBrush(BACKGROUND_COLOR));
    setSceneRect(0, 0, width, height);

    // draw the lattice grids
    QPen pen(LATTICE_COLOR);
    pen.setWidth(GRID_WIDTH);
    int temp = 0;
    for (int i = 0; i <= column; i++) {
        addLine(temp, 0, temp, height, pen);
        temp += LATTICE_SIZE;
    }
    temp = 0;
    for (int i = 0; i <= row; i++) {
        addLine(0, temp, width, temp, pen);
        temp += LATTICE_SIZE;
    }

    // add the chessmen
    QGraphicsPixmapItem *p = NULL;
    QPixmap pixmap(":/image/white.png");
    int x = (LATTICE_SIZE - CHESS_SIZE) >> 1;
    int y = 0;
    Chess chess;
    for (int i = 0; i < column; i++) {
        y = (LATTICE_SIZE - CHESS_SIZE) >> 1;
        for (int j = 0; j < row; j++)
        {
            p = addPixmap(pixmap);
            p->moveBy(x, y);
            chess.isWhite = true;
            chess.item = p;
            board[i][j] = chess;
            y += LATTICE_SIZE;
        }
        x += LATTICE_SIZE;
    }
}

void Scene::mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent)
{
    QGraphicsPixmapItem *item = reinterpret_cast<QGraphicsPixmapItem*>(itemAt(mouseEvent->lastScenePos()));
    for (int i = 0; i < column; i++) {
        for (int j = 0; j < row; j++) {
            if (item == board[i][j].item) {
                clicks++;

                QPixmap black(":/image/black.png");
                QPixmap white(":/image/white.png");

                // flip
                board[i][j].isWhite = !board[i][j].isWhite;
                board[i][j].item->setPixmap((board[i][j].isWhite) ? (white) : (black));

                if (i > 0) {
                    board[i - 1][j].isWhite = !board[i - 1][j].isWhite;
                    board[i - 1][j].item->setPixmap((board[i - 1][j].isWhite) ? (white) : (black));
                }

                if (i < column - 1) {
                    board[i + 1][j].isWhite = !board[i + 1][j].isWhite;
                    board[i + 1][j].item->setPixmap((board[i + 1][j].isWhite) ? (white) : (black));
                }

                if (j > 0) {
                    board[i][j - 1].isWhite = !board[i][j - 1].isWhite;
                    board[i][j - 1].item->setPixmap((board[i][j - 1].isWhite) ? (white) : (black));
                }

                if (j < row - 1) {
                    board[i][j + 1].isWhite = !board[i][j + 1].isWhite;
                    board[i][j + 1].item->setPixmap((board[i][j + 1].isWhite) ? (white) : (black));
                }

                // check if all turned to black
                for (int i2 = 0; i2 < column; i2++) {
                    for (int j2 = 0; j2 < row; j2++) {
                        if (board[i2][j2].isWhite)
                            return;
                    }
                }
                emit gameFinished(clicks);
                return;
            }
        }
    }

    QGraphicsScene::mousePressEvent(mouseEvent);
}
