#!/usr/bin/python

import gtk
import hildon

import re
import os
import cPickle
from copy import deepcopy
from time import time
from sys import argv,exit

###############################################################################
# Initialisation of global variables and defaults

BASE_DIR = os.getenv('HOME') + '/.tubes/'
if not os.path.exists(BASE_DIR):
	os.mkdir(BASE_DIR)

DATA_DIR = BASE_DIR + 'Data/'
STATIONS_FILE = 'Stations'
DATA_FILE = BASE_DIR + 'Tubes.dat'
CLOSURES_FILE = BASE_DIR + 'Closures.txt'
CONFIG_FILE = 'Config.txt'

CLOSURES_TIMEOUT = 300

CHANGE_MARKER = "change"

CHANGE_PENALTY = 5
STOP_PENALTY = 1
BUS_PENALTY = 10
DELAY_PENALTY = 10
DEFAULT_TIME = 2

INFINITY = 1E31

STATION_NAME = 0
STATION_HASH = 1
STATION_ZONES = 2
STATION_LINES = 3
STATION_NOCHANGE = 4
STATION_TIMES = 5
STATION_DISTANCE = 6
Station = [{}, {}, {}, {}, {}, {}, {}]

LINE_STOP = 0
LINE_DIRECTIONS = 1
LINE_GROUPS = 2
Line = [{}, {}, {}]

station_from = ""
station_to = ""


###############################################################################
# Routines to clean and match approximately entered station names

def soundex(name, len=5):
	digits = '01230120022455012023010202'
	sndx = ''
	fc = ''
	for c in name.upper():
		if c.isalpha():
			if not fc: fc = c
			d = digits[ord(c)-ord('A')]
			if not sndx or (d != sndx[-1]):
				sndx += d
	sndx = fc + sndx[1:]
	sndx = sndx.replace('0','')
	return (sndx + (len * '0'))[:len]

def matchStation(station):
	station = cleanString(station)
	if station == "":
		return None
	if Station[STATION_NAME].has_key(station):
		return station
	else:
		if len(station ) >= 4:
			for station_ in Station[STATION_NAME]:
				tmp = re.search(station, station_)
				if tmp != None:
					if tmp.start() == 0:
						return station_
			for station_ in Station[STATION_NAME]:
				tmp = re.search(station, station_)
				if tmp != None:
					return station_
		input_hash = soundex(station)
		minimum = ["", INFINITY]
		for station_ in Station[STATION_NAME]:
			diff = abs((ord(input_hash[0]) - ord(Station[STATION_HASH][station_][0])) * 10000 + (int(input_hash[1:]) - int(Station[STATION_HASH][station_][1:])))
			if diff < minimum[1]:
				minimum = [station_, diff]
		return minimum[0]

def cleanString(string):
	return str.lower(str.strip(string))


###############################################################################
# Populate the station and line data arrays (load from file or pickle)

if os.path.exists(DATA_FILE):
	[Station, Line] = cPickle.load(open(DATA_FILE, 'r'))
else:
	if not os.path.exists(DATA_DIR):
		print "Error: Neither data file nor database found."
		exit()
	f = open(DATA_DIR + STATIONS_FILE)
	for station in f.readlines():
		station = str.split(str.split(station, '#')[0].strip(), '\t')
		name = station[0]
		station[0] = cleanString(station[0]).replace(',', '')
		Station[STATION_NAME][station[0]] = name
		Station[STATION_HASH][station[0]] = soundex(name)
		Station[STATION_ZONES][station[0]] = []
		Station[STATION_LINES][station[0]] = []
		Station[STATION_DISTANCE][station[0]] = [INFINITY, False]
		for zone in str.split(station[1], ';'):
			Station[STATION_ZONES][station[0]].append(int(zone))

	TubeLines = os.listdir(DATA_DIR)
	for line in TubeLines:
		if line != STATIONS_FILE:
			Line[LINE_STOP][line] = []
			Line[LINE_DIRECTIONS][line] = []
			Station[STATION_TIMES][line] = []
			f = open(DATA_DIR + line)
			for stop in f.readlines():
				stop = str.split(stop, '#')[0].strip()
				if len(Line[LINE_DIRECTIONS][line]) == 0:
					directions = str.split(str.strip(stop), '\t')
					if len(directions) < 1:
						directions = [""]
					if len(directions) < 2:
						directions.append("")
					Line[LINE_DIRECTIONS][line] = directions
				else:
					stop = str.strip(str.lower(stop))
					if stop != "":
						stop = str.split(stop, '\t')
						Line[LINE_STOP][line].append(stop[0])
						if len(stop) > 1:
							Station[STATION_TIMES][line].append(int(stop[1]))
						else:
							Station[STATION_TIMES][line].append(DEFAULT_TIME)
						Station[STATION_LINES][stop[0]].append(line)
			f.close()

	for line in Line[LINE_STOP].keys():
		superline = line.partition("(")[0].strip()
		if not Line[LINE_GROUPS].has_key(superline):
			Line[LINE_GROUPS][superline] = [superline]
		if superline != line:
			Line[LINE_GROUPS][superline].append(line)

	cPickle.dump([Station, Line], open(DATA_FILE, 'w'))


###############################################################################
# Populate the station and line closures array (load from file)

closures = []
closures_time = -1
def get_closures():
	import closures
	closures.get(CLOSURES_FILE)

	f = open(CLOSURES_FILE)
	closures_ = [str.split(str.split(line, '#')[0].strip(), ';') for line in f.readlines()]
	i = 0
	while i < len(closures_):
		if closures_[i] != [""]:
			closures = closures_[i:]
			i = len(closures_)
		i += 1
	if len(closures) < 1:
		closures = [[],[]]
	if len(closures) < 2:
		closures.append([])
	if len(closures) < 3:
		closures.append([])
	if len(closures) < 4:
		closures.append([])
	for line in closures[0]:
		part = str.split(line.strip(), ',')
		if len(part) >= 3:
			if Line[LINE_GROUPS].has_key(part[0]):
				for line in Line[LINE_GROUPS][part[0]]:
					try:
						closed_from = min(Line[LINE_STOP][line].index(cleanString(part[1])), Line[LINE_STOP][line].index(cleanString(part[2])))
						closed_to = max(Line[LINE_STOP][line].index(cleanString(part[1])), Line[LINE_STOP][line].index(cleanString(part[2])))
						for i in range(closed_to - closed_from):
							if len(part) == 3:
								Station[STATION_TIMES][line][i + closed_from] = INFINITY
							else:
								Station[STATION_TIMES][line][i + closed_from] += BUS_PENALTY
								Station[STATION_TIMES][line][i + closed_from] *= -1
					except ValueError:
						pass
	for line in closures[1]:
		if Station[STATION_TIMES].has_key(line):
			for i in range(len(Station[STATION_TIMES][line])):
				Station[STATION_TIMES][line][i] += DELAY_PENALTY
	for i in range(len(closures[2])):
		closures[2][i] = cleanString(closures[2][i])
	for station in closures[3]:
		part = str.split(station.strip(), ',')
		if len(part) == 3:
			if not Station[STATION_NOCHANGE].has_key(cleanString(part[0])):
				Station[STATION_NOCHANGE][cleanString(part[0])] = []
			Station[STATION_NOCHANGE][cleanString(part[0])].append("%s,%s" % (part[1], part[2]))
	f.close()
	return closures


###############################################################################
# Load some configuration data

if os.path.exists(BASE_DIR + CONFIG_FILE):
	f = open(BASE_DIR + CONFIG_FILE, 'r')
	lines = f.readlines()
	f.close()
	for line in lines:
		line = line.split('=')
		if (line[0] == "stations") and (len(line) == 2):
			data = line[1].split(',')
			if len(data) == 2:
				[station_from, station_to] = data


###############################################################################
# Devise a route between two stations

def route(station_from, station_to):
	def getclosest(distances):
		closest_dist = INFINITY
		for station in distances:
			if (distances[station][0] <= closest_dist) and (distances[station][1] == False):
				closest_dist = distances[station][0]
				closest_station = station
		return closest_station
	def empty(distances):
		for station in distances:
			if not distances[station][1]:
				return False
		return True

	station_from = cleanString(station_from)
	station_to = cleanString(station_to)
	if (not (Station[STATION_DISTANCE].has_key(station_from) and Station[STATION_DISTANCE].has_key(station_to))) or (station_from in closures[2]) or (station_to in closures[2]):
		return None
	previous = {}

	V = {}
	E = []
	for station in Station[STATION_LINES]:
		if (station != station_from) and not (station in closures[2]):
			for line_1 in Station[STATION_LINES][station]:
				for line_2 in Station[STATION_LINES][station]:
					line_1 = line_1.partition("(")[0].strip()
					line_2 = line_2.partition("(")[0].strip()
					if line_1 != line_2:
						tmp = True
						if Station[STATION_NOCHANGE].has_key(station):
							tmp = not ((("%s,*" % line_1) in Station[STATION_NOCHANGE][station]) or (("%s,*" % line_2) in Station[STATION_NOCHANGE][station]) or (("%s,%s" % (line_1, line_2)) in Station[STATION_NOCHANGE][station]))
						if tmp:
							E.append([station, station, "%s;%s,%s" % (CHANGE_MARKER, line_1, line_2), CHANGE_PENALTY, CHANGE_MARKER])
		for line in Station[STATION_LINES][station]:
			idx = Line[LINE_STOP][line].index(station)
			line_ = line.partition("(")[0].strip()
			tmp = not (line_ in closures[0])
			if Station[STATION_NOCHANGE].has_key(station):
				tmp = not ("%s,*" % line_) in Station[STATION_NOCHANGE][station]
			if tmp:
				for offset in [-1,1]:
					if (idx + offset >= 0) and (idx + offset < len(Line[LINE_STOP][line])) and (Line[LINE_DIRECTIONS][line][1-(offset + 1)/2] != ""):
						time = Station[STATION_TIMES][line][idx + (offset - 1)/2]
						dirn = Line[LINE_DIRECTIONS][line][1-(offset + 1)/2]
						if time < 0:
							dirn = "rail replacement bus"
						time = abs(time)
						E.append([station, Line[LINE_STOP][line][idx+offset], line_, time, dirn])
				if station != station_from:
					key = "%s,%s" % (station,line_)
					if not V.has_key(key):
						V[key] = [INFINITY, False]
				else:
					key = "%s,%s" % (station, line_)
					if not V.has_key(key):
						V[key] = [0, False]
	V[station_from] = [0, False]

	while not empty(V):
		station = getclosest(V)
		station_name = station.split(',')[0]
		line_name = ""
		if len(station.split(',')) > 1:
			line_name = station.split(',')[1]
		if V[station][0] == INFINITY:
			break
		V[station][1] = True
		distance = V[station][0]
		for edge in E:
			if edge[0] == station_name:	
				parts = edge[2].partition(';')
				if parts[0] in [line_name, CHANGE_MARKER]:
					edge[2] = line_name
					if parts[0] == CHANGE_MARKER:
						lines = parts[2].partition(',')
						edge[2] = lines[0]
						if lines[0] == line_name:
							edge[2] = lines[2]
					key = ','.join(edge[1:3])
					d_distance = edge[3]
					if V.has_key(key):
						if (distance + d_distance) < V[key][0]:
							V[key][0] = distance + d_distance
							previous[key] = [station_name, line_name, V[key][0], edge[4]]

	minimum = [INFINITY, -1, ""]
	for line in Station[STATION_LINES][station_to]:
		line_ = line.partition("(")[0].strip()
		key = "%s,%s" % (station_to, line_)
		if previous.has_key(key):
			if previous[key][2] <= minimum[0]:
				minimum = [previous[key][2], key, line_]

	path = []
	x = [station_to, minimum[2], minimum[0], ""]
	while x[0] != station_from:
		path.append(x)
		key = ','.join(x[0:2])
		if previous.has_key(key):
			x = previous[key]
		else:
			return None
	path.append(x)
	path.reverse()
	dist = 0
	for leg in path:
		tmp = leg[2]
		leg[2] -= dist
		dist = tmp
	return path


###############################################################################
# Return a plan for the route

def plan(station_from, station_to):
	station_from = cleanString(station_from)
	station_to = cleanString(station_to)
	plans = []
	if not (Station[STATION_DISTANCE].has_key(station_from) and Station[STATION_DISTANCE].has_key(station_to)):
		return None
	rte = route(station_from, station_to)
	changes = []
	stops = []
	lines = []
	directions = []
	time = 0
	if rte != None:
		for i in range(len(rte)):
			rte[i][1] = rte[i][1].partition("(")[0].strip()
			if i == 0:
				changes.append(rte[i][0])
				lines.append(rte[i][1])
				directions.append(rte[i][3])
				stops.append(0)
			else:
				if rte[i][3] != CHANGE_MARKER:
					if (rte[i][1] != lines[len(lines) - 1]) or (rte[i][3] != directions[len(directions)-1]):
						changes.append(rte[i][0])
						lines.append(rte[i][1])
						directions.append(rte[i][3])
						stops[len(stops) - 1] += 1
						stops.append(0)
					else:
						stops[len(stops) - 1] += 1
			time += rte[i][2]
		for stop in stops:
			time += (stop > 0) * (stop - 1) * STOP_PENALTY
		return [changes, lines, directions, stops, time]


###############################################################################
# Return a human readable version of the given route

def parse(plan, indent=""):
	def zones(station):
		tmp = ""
		for zone in Station[STATION_ZONES][station]:
			tmp += ", %d" % zone
		return "zone" + suffix(tmp.count(',')) + " " + tmp[2:]
	def suffix(number, singular="", plural="s"):
		if number != 1:
			return plural
		else:
			return singular
	tmp = ""
	if plan != None:
		if len(plan[0]) > 1:
			for i in range(len(plan[0])):
				if i == 0:
					tmp = "%s(%d) Take %s line (%s) from %s (%s) for %d stop%s.\n" % (indent, (i + 1), plan[1][0], plan[2][i], Station[STATION_NAME][plan[0][0]], zones(plan[0][0]), plan[3][0], suffix(plan[3][0]))
				elif i == len(plan[0]) - 1:
					tmp += "%s(%d) Arrive at %s (%s) after %d minute%s." % (indent, (i + 1), Station[STATION_NAME][plan[0][i]], zones(plan[0][i]), plan[4], suffix(plan[4]))
				else:
					tmp += "%s(%d) Switch to %s line (%s) at %s and continue for %d stop%s.\n" % (indent, (i + 1), plan[1][i], plan[2][i], Station[STATION_NAME][plan[0][i]], plan[3][i], suffix(plan[3][i]))
		else:
			tmp += "%sNo route possible" % indent
	else:
		tmp += "%sNo route found" % indent
	return tmp


###############################################################################
# Return a human readable version of the route from one station to another

def guide(station_from, station_to):
	global closures, closures_time
	if (time() - closures_time) > CLOSURES_TIMEOUT:
		closures = get_closures()
		closures_time = time()
	return parse(plan(matchStation(station_from), matchStation(station_to)))


###############################################################################

def main():
	global station_from, station_to

	def switch_fields(from_entry, to_entry):
		tmp = from_entry.get_text()
		from_entry.set_text(to_entry.get_text())
		to_entry.set_text(tmp)

	def showdialog(title, route):
		dialog = gtk.Dialog("Tube route", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
		dialog.add_button("Get route", gtk.RESPONSE_OK)
		dialog.add_button("Cancel", -1)
		from_hbox = gtk.HBox()
		from_hbox.pack_start(gtk.Label("From:"), False, False, 5)
		from_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
		from_entry.set_max_length(40)
		from_entry.set_text(title.station_from)
		from_hbox.pack_start(from_entry, True, True, 5)
		to_hbox = gtk.HBox()
		to_hbox.pack_start(gtk.Label("To:"), False, False, 5)
		to_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
		to_entry.set_max_length(40)
		to_entry.set_text(title.station_to)
		to_hbox.pack_start(to_entry, True, True, 5)
		fields_vbox = gtk.VBox()
		fields_vbox.pack_start(from_hbox, True, True, 0)
		fields_vbox.pack_end(to_hbox, True, True, 0)
		everything = gtk.HBox()
		everything.pack_start(fields_vbox, True, True, 0)
		switch = gtk.Button("Switch")
		switch.connect("clicked", lambda button: switch_fields(from_entry, to_entry))
		everything.pack_end(switch, True, True, 0)
		dialog.vbox.pack_start(everything, True, True, 0)
		dialog.show_all()
		response = dialog.run()
		title.station_from = from_entry.get_text().strip()
		title.station_to = to_entry.get_text().strip()
		dialog.destroy()
		if (response == gtk.RESPONSE_OK) and (title.station_from != "") and (title.station_to != ""):
			title.set_markup("<big>%s to %s</big>" % (Station[STATION_NAME][matchStation(title.station_from)], Station[STATION_NAME][matchStation(title.station_to)]))
			route.set_markup(guide(title.station_from, title.station_to))

	win = hildon.StackableWindow()
	win.set_title("Tube route")
	vbox = gtk.VBox()
	title = gtk.Label()
	title.station_from = station_from
	title.station_to = station_to
	title.set_markup("<big>No route</big>")
	vbox.pack_start(title, True, True, 5)
	vbox.pack_start(gtk.Label(""), True, True, 5)
	route = gtk.Label()
	route.set_markup("")
	route.set_line_wrap(True)
	button = gtk.Button("New route")
	button.connect("clicked", lambda button: showdialog(title, route))
	vbox.pack_start(route, True, True, 5)
	vbox.pack_start(gtk.Label(""), True, True, 5)
	vbox.pack_end(button, True, True, 5)
	win.add(vbox)
	win.connect("destroy", gtk.main_quit, None)
	win.show_all()

	showdialog(title, route)
	gtk.main()

	###############################################################################
	# Save some configuration data

	f = open(BASE_DIR + CONFIG_FILE, 'w')
	if f:
		f.write("stations=%s,%s" % (title.station_from, title.station_to))
		f.close()

main()
