/* Copyright (C) 2006 - 2010 Jan Kundrát <jkt@gentoo.org>

   This file is part of the Trojita Qt IMAP e-mail client,
   http://trojita.flaska.net/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or the version 3 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _MESSAGE_WINDOW_H_
#define _MESSAGE_WINDOW_H_

#include <QMainWindow>
#include <QMaemo5InformationBox>

#include "BaseWindow.h"
#include "Imap/ConnectionState.h"
#include "Imap/Model/Cache.h"

class QAuthenticator;
class QItemSelection;
class QModelIndex;
class QProgressBar;
class QScrollArea;
class QToolButton;
class QTreeView;
class QSortFilterProxyModel;
class QHideEvent;

namespace Imap {
namespace Mailbox {

class Model;
class TreeItemMessage;

}
}

namespace Gui {

class MainWindow;
class MessageView;
class MsgListView;
class ProtocolLoggerWidget;

class MessageWindow: public BaseWindow {
    Q_OBJECT
    typedef QList<QPair<QString,QString> > _recipientsType;
public:
    MessageWindow(const QModelIndex& index, Imap::Mailbox::Model* model, QWidget* parent=0);

protected:
    virtual void hideEvent ( QHideEvent  * event );

private slots:
    void slotReplyTo();
    void slotReplyAll();
    void handleMarkAsDeleted( bool );
    void slotComposeMailUrl( const QUrl& url );
    
private:
    void createMenus();
    void createActions();
    void createWidgets();
    void setupModels();

    void connectModelActions();

    void createMailboxBelow( const QModelIndex& index );

    void updateActionsOnlineOffline( bool online );

    Imap::Mailbox::Model* model;
    const QModelIndex& index;

    QScrollArea* area;
    MessageView* msgView;

    QAction* replyTo;
    QAction* replyAll;
    QAction* markAsDeleted;

    MessageWindow(const MessageWindow&); // don't implement
    MessageWindow& operator=(const MessageWindow&); // don't implement
};

}

#endif
