/* Copyright (C) 2006 - 2010 Jan Kundrát <jkt@gentoo.org>

   This file is part of the Trojita Qt IMAP e-mail client,
   http://trojita.flaska.net/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or the version 3 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _MESSAGE_LIST_WINDOW_H_
#define _MESSAGE_LIST_WINDOW_H_

#include <QMainWindow>
#include <QMaemo5InformationBox>

#include "BaseWindow.h"
#include "Imap/ConnectionState.h"
#include "Imap/Model/Cache.h"

class QAuthenticator;
class QItemSelection;
class QModelIndex;
class QProgressBar;
class QScrollArea;
class QToolButton;
class QTreeView;
class QSortFilterProxyModel;

namespace Imap {
namespace Mailbox {

class Model;
class MailboxModel;
class MsgListModel;
class PrettyMailboxModel;
class TreeItemMailbox;

}
}

namespace Gui {

class MessageWindow;
class MessageView;
class MsgListView;
class ProtocolLoggerWidget;

class MessageListWindow: public BaseWindow {
    Q_OBJECT
    typedef QList<QPair<QString,QString> > _recipientsType;
public:
    MessageListWindow(const QModelIndex& index, Imap::Mailbox::Model* model, QWidget* parent=0);
    void invokeComposeDialog( const QString& subject = QString(),
                              const QString& body = QString(),
                              const _recipientsType& recipients = _recipientsType() );

private slots:
    void showContextMenuMsgListTree( const QPoint& position );
    void slotResyncMbox();
    void slotResizeMsgListColumns();
    void slotExpunge();
    void handleMarkAsRead( bool );
    void handleMarkAsDeleted( bool );
    void msgListClicked( const QModelIndex& );
    void msgListSelectionChanged( const QItemSelection& selected, const QItemSelection& deselected );
    void updateMessageFlags();
    void updateActionsOffline() { updateActionsOnlineOffline(false); };
    void updateActionsOnline() { updateActionsOnlineOffline(true); };
    
private:
    void createMenus();
    void createActions();
    void createWidgets();
    void setupModels();

    void createMailboxBelow( const QModelIndex& index );

    void updateActionsOnlineOffline( bool online );

    MessageWindow* messageWindow;
    Imap::Mailbox::Model* model;
    Imap::Mailbox::MsgListModel* msgListModel;
    QSortFilterProxyModel* msgListProxy;

    MsgListView* msgListTree;

    QAction* resyncMbox;
    QAction* expunge;

    QAction* markAsRead;
    QAction* markAsDeleted;

    MessageListWindow(const MessageListWindow&); // don't implement
    MessageListWindow& operator=(const MessageListWindow&); // don't implement
};

}

#endif
