/* Copyright (C) 2006 - 2010 Jan Kundrát <jkt@gentoo.org>

   This file is part of the Trojita Qt IMAP e-mail client,
   http://trojita.flaska.net/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or the version 3 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef TROJITA_WINDOW_H
#define TROJITA_WINDOW_H

#include <QMainWindow>
#include <QMaemo5InformationBox>

#include "BaseWindow.h"
#include "Imap/ConnectionState.h"
#include "Imap/Model/Cache.h"

class QAuthenticator;
class QItemSelection;
class QModelIndex;
class QProgressBar;
class QScrollArea;
class QToolButton;
class QTreeView;
class QSortFilterProxyModel;

namespace Imap {
namespace Mailbox {

class Model;
class MailboxModel;
class MsgListModel;
class PrettyMailboxModel;

}
}

namespace Gui {

class MessageListWindow;
class ProtocolLoggerWidget;

class MainWindow: public BaseWindow {
    Q_OBJECT
    typedef QList<QPair<QString,QString> > _recipientsType;
public:
    MainWindow();

public slots:
    void showContextMenuMboxTree( const QPoint& position );
    void slotReloadMboxList();
    void cacheError( const QString& message );
    void mboxClicked( const QModelIndex& );
    void slotCreateMailboxBelowCurrent();
    void slotCreateTopMailbox();
    void slotDeleteCurrentMailbox();

    void slotMailboxDeleteFailed( const QString& mailbox, const QString& msg );
    void slotMailboxCreateFailed( const QString& mailbox, const QString& msg );

private:
    void createMenus();
    void createActions();
    void createWidgets();
    void setupModels();

    void connectModelActions();

    void createMailboxBelow( const QModelIndex& index );

    Imap::Mailbox::MailboxModel* mboxModel;
    Imap::Mailbox::PrettyMailboxModel* prettyMboxModel;

    QTreeView* mboxTree;

    MessageListWindow* messageListWindow;

    ProtocolLoggerWidget* imapLogger;
    QDockWidget* imapLoggerDock;

    QAction* reloadMboxList;
    QAction* reloadAllMailboxes;
    QAction* showImapLogger;
    QAction* showMenuBar;
    QAction* createChildMailbox;
    QAction* createTopMailbox;
    QAction* deleteCurrentMailbox;

    MainWindow(const MainWindow&); // don't implement
    MainWindow& operator=(const MainWindow&); // don't implement
};

}

#endif
