#ifndef TUBEAPI_H
#define TUBEAPI_H

#include <QObject>
#include <QStringList>
#include <QUrl>

class QNetworkReply;

const int STATUS_FUNC = 1;
const int ROUTING_FUNC = 2;

class TubeApi : public QObject
{
    Q_OBJECT

public:
    TubeApi( QObject *parent, int function);
    virtual ~TubeApi();
	void setUrl(QUrl url);
    QStringList results() const;
	void setRoutingFunc() { _function = ROUTING_FUNC; }
	void setStatusFunc() { _function = STATUS_FUNC; }
	bool isRoutingFunc() { return (_function == ROUTING_FUNC); }
	bool isStatusFunc() { return (_function == STATUS_FUNC); }

signals:
    void finished( bool success );

public slots:
    void search();

private slots:
    void finished( QNetworkReply *reply );

private:
    bool processStatusApiResult( QIODevice *source );
    bool processRoutingApiResult( QIODevice *source );

    struct TubeApiPrivate *d;
	int _function;
};

#endif // TUBEAPI_H
