/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Afaque Hussain <afaquejam@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef TEXTTRANSLATE_H
#define TEXTTRANSLATE_H




#include <QtGui/QWidget>
#include <QtCore/QFile>
#include <QtCore/QString>
#include <QtGui/QTextEdit>
#include <QtGui/QComboBox>
#include <QtGui/QPushButton>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtCore/QTextCodec>
#include <QtCore/QDebug>
#include <QtGui/QDialog>
#include <QtGui/QFileDialog>
#include <QtNetwork/QHttp>
#include <QtMaemo5/QMaemo5InformationBox>


class TextTranslate : public QDialog
{
   Q_OBJECT

public :

        TextTranslate();


public slots :
        void sourceLanguageSelect(int index);
        void targetLanguageSelect(int index);
        void doTranslation();
        void showTranslation();
        void loadDocument();

signals :


private :
        QString filePath;
        QDialog *outputDialog;
        QTextEdit *sourceText;
        QTextEdit *translatedText;
        QString sourceLanguageCode;
        QString targetLanguageCode;
        QHttp *httpRequest;

};


#endif // TEXTTRANSLATE_H
