# -*- coding: utf-8 -*-
from PyQt4.QtGui import QDialog, QPushButton, QGridLayout, QLabel, QCheckBox

class PushDialog(QDialog):
    Cancel = 0
    Forget = 1
    ForgetAndUnlock = 2
    Push = 3
    PushAndUnlock = 4
    Save = 5
    def __init__(self, remote=True, locked=True, parent=None):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Confirmation")
        self.resize(600,200)

        buttonForget = QPushButton("&Forget changes", parent=self)
        buttonCancel = QPushButton("&Continue translating", parent=self)

        label = QLabel("The file has been modifed. Do you want to save changes"+
        " locally or push them back to server?", parent=self)
        label.setWordWrap(True)

        layout = QGridLayout(self)

        if remote:
            checkboxKeepLocked = QCheckBox("Keep &locked", parent=self)
            checkboxKeepLocked.setChecked(locked)
            buttonPush = QPushButton("Pu&sh", parent=self)
            buttonPush.clicked.connect(lambda : self.done(
                {
                    True : self.Push,
                    False : self.PushAndUnlock
                }[checkboxKeepLocked.isChecked()]))
            buttonForget.clicked.connect(lambda : self.done(
                {
                    True : self.Forget,
                    False : self.ForgetAndUnlock
                }[checkboxKeepLocked.isChecked()]))
            buttonCancel.clicked.connect(lambda : self.done(self.Cancel))
            layout.addWidget(label, 0, 0, 1, 3)
            layout.addWidget(checkboxKeepLocked, 1, 0, 1, 3)
            layout.addWidget(buttonPush,   2, 0)
            layout.addWidget(buttonForget, 2, 1)
            layout.addWidget(buttonCancel, 2, 2)            
        else:
            buttonSave = QPushButton("&Save", parent=self)
            buttonSave.clicked.connect(lambda : self.done(self.Save))
            buttonForget.clicked.connect(lambda : self.done(self.Forget))
            buttonCancel.clicked.connect(lambda : self.done(self.Cancel))
            layout.addWidget(label, 0, 0, 1, 3)
            layout.addWidget(buttonSave,   1, 0)
            layout.addWidget(buttonForget, 1, 1)
            layout.addWidget(buttonCancel, 1, 2)            
            
            

        self.setLayout(layout)