# -*- coding: utf-8 -*-

import hashlib
import urllib
import os

from PyQt4.QtGui import QIcon
from PyQt4.QtCore import QSize

GRAVATAR_CACHE_FILENAME = "%(home)s/.gravatar-cache/%(size)ix%(size)i/%(md5)s.jpeg"
GRAVATAR_URL = "http://www.gravatar.com/avatar/%(md5)s?size=%(size)i"

class QGravatar(QIcon):
    def __init__(self, email, size=64):
        self.size = size
        md5 = hashlib.md5(email).hexdigest()
        args = {'md5':md5,'size':size,'home':os.getenv('HOME')}
        self.url = GRAVATAR_URL % args
        self.filename = GRAVATAR_CACHE_FILENAME % args
        directory = os.path.dirname(self.filename)
        if not os.path.isfile(self.filename):
            if not os.path.isdir(directory):
                os.makedirs(directory)
            fin = urllib.urlopen(self.url)
            data = fin.read()
            fin.close()
            fout = open(self.filename, "wb")
            fout.write(data)
            fout.close()    
        QIcon.__init__(self, self.filename)
        #QIcon.resize(self, self.size, self.size)
#        self.setIconSize(self.size, self.size)

    def minimumSize(self):
        return QSize(self.size, self.size)

        