# -*- coding: utf-8 -*-
from PyQt4.Qt import Qt, pyqtSignal
from PyQt4.QtGui import QTableView, QAbstractItemView
from PyQt4.QtCore import QModelIndex, QTimer, QThread, QAbstractTableModel
from common import CustomWindow
from components.model import ComponentListModel
from files.model import FileListModel
from gettextfile.view import FileView
from config import config

class FileListViewThread(QThread):
    finishFetch = pyqtSignal(QAbstractTableModel)
    def run(self):
        target = self.parent()
        listmodel = FileListModel(project = target.project, component = target.component, parent=None)
        listmodel.moveToThread(target.thread())
        listmodel.setParent(self)
        self.finishFetch.emit(listmodel)

class FilesView(CustomWindow):
    def __init__(self, parent=None, project=None, component=None):
        CustomWindow.__init__(self, parent, title=u"Loading files...")
        self.project = project
        self.component = component
        self.tableview = QTableView(self)
        self.tableview.setSelectionMode(QAbstractItemView.NoSelection)
        self.tableview.setProperty("FingerScrollable", True)
        self.tableview.setEnabled(False)
        self.setCentralWidget(self.tableview)
        self.fetchThread = FileListViewThread(self)
        self.fetchThread.finishFetch.connect(self.finishFetch)
        self.fetchThread.start()

    def finishFetch(self, listmodel):
        self.listmodel = listmodel
        self.tableview.setModel(listmodel)
        for i in [0,1,2]:
            self.tableview.resizeColumnToContents(i)
        self.tableview.resizeRowsToContents()
        self.tableview.clicked.connect(self.openFile)
        self.setWindowTitle(u"Files of %s/%s" % (self.project.title, self.component.title))
        self.toggleBusy(False)
        self.tableview.setEnabled(True)

    def openFile(self, index):
        remotefile = self.listmodel.data(index)
        config.bookmarksChanged.emit()
        obj = FileView(parent=self, fp=remotefile)
        obj.show()
