#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, os
from PyQt4.QtGui import QApplication

def ls(directory, extension = "po"):
    return [os.path.join(directory, filename)
      for filename in os.listdir(os.path.expanduser(directory))
      if filename.lower().endswith(".%s" % extension)]

from servers.model import ServerModel
from servers.view import ServerView
from gettextfile.view import FileView
from files.model import LocalFileModel

import logging

def entry_point():
    args = sys.argv[1:]
    if '-d' in args:
        args.remove('-d')
        level = logging.DEBUG
    else:
        level = logging.ERROR
    logging.basicConfig(level=level)
    app = QApplication(sys.argv + ['-title','Transifex-mobile'])
    if args == []:
        model = ServerModel("www.transifex.net", "Transifex.net")
        win = ServerView(model)
    elif len(args) == 1:
        filename, = args
        win = FileView(fp=LocalFileModel(filename))
    else:
        sys.exit(1)
    win.show()
    sys.exit(app.exec_())

if __name__ == "__main__":
    entry_point()
