# -*- coding: utf-8 -*-
import os
from setuptools import setup, Command
import shutil
import time

# TODO: Implement reading files from setuptools resource management

DESCRIPTION = """Mobile translation application."""

KEYWORDS = """localization l10n internationalization i18n
transifex pyqt pyqt4 qt qt4"""

DCH = """
EMAIL="lauri.vosandi@gmail.com"
NAME="Lauri Võsandi"
dch --newversion "0.1~git%Y%m%d" "Git trunk snapshot for %d. of %B, %Y"
"""

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()
    
class MyCommand(Command):
    user_options = []
    def initialize_options(self):
        pass

    def finalize_options(self):
        pass
        
class ExpandTabsCommand(MyCommand):
    description = "Expand tabs in Python files"
    def run(self):
        root = os.path.dirname(os.path.realpath(__file__))
        for prefix, _, files in os.walk(root):
          for relpath in files:
            fullpath = os.path.join(prefix, relpath)
            if fullpath.endswith(".py"):
              fh = open(fullpath, "ru")
              data = fh.read()
              fh.close()
              if '\t' in data:
                print "expand %s" % fullpath
                fh = open(fullpath, "wu")
                fh.write(data.replace('\t', '        '))
                fh.close()

class CleanCommand(MyCommand):
    description = "Remove temporary files"
    def run(self):
        root = os.path.dirname(os.path.realpath(__file__))
        for relpath in ['build','dist','transifex_mobile.egg-info',
          'debian/python-module-stampdir', 'debian/transifex-mobile',
          'debian/files', 'debian/pycompat',
          'debian/transifex-mobile.debhelper.log',
          'debian/transifex-mobile.postinst.debhelper',
          'debian/transifex-mobile.preinst.debhelper',
          'debian/transifex-mobile.prerm.debhelper',
          'debian/transifex-mobile.substvars']:
          fullpath = os.path.join(root, relpath)
          if os.path.isdir(fullpath):
            print "rm -R %s" % fullpath
            shutil.rmtree(fullpath)
          elif os.path.isfile(fullpath):
            print "rm %s" % fullpath
            os.remove(fullpath)
        for prefix, _, files in os.walk(root):
          for relpath in files:
            fullpath = os.path.join(prefix, relpath)
            if fullpath.endswith("~") or \
              fullpath.endswith(".pyc") or \
              fullpath.endswith(".pyo"):
                print "rm %s" % fullpath
                os.remove(fullpath)

class UpdateDebianChangelogCommand(MyCommand):
    description = "Update Debian changelog"
    def run(self):
        os.system(time.strftime(DCH).replace("\n"," "))
        

class BuildDebianPackageCommand(MyCommand):
    description = "Build Debian package"
    def run(self):
        os.system("fakeroot dpkg-buildpackage")


setup(
    name = "transifex-mobile",
    version = "0.1",
    author = "Lauri Võsandi",
    author_email = "lauri.vosandi@gmail.com",
    description = DESCRIPTION.replace('\n', ' '),
    license = "BSD",
    keywords = KEYWORDS.replace('\n', ' '),
    url = "http://packages.python.org/transifex-mobile",
    zip_safe = False,
    include_package_data = True,
#    data_files = [('icons',find_icons('icons')),],
    cmdclass = {
        'clean' : CleanCommand,
        'expand' : ExpandTabsCommand,
        'dpkg_buildpackage' : BuildDebianPackageCommand,
        'dch' : UpdateDebianChangelogCommand,
    },
    entry_points={
        'console_scripts': ['transifex-mobile = main:entry_point',],
    },
    packages=['gettextfile','views'],
    py_modules=['common','main', 'config'],
    long_description=read('README'),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Topic :: Utilities",
        "License :: OSI Approved :: BSD License",
    ],
)
