#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, os
from PyQt4.QtGui import QApplication

def ls(directory, extension = "po"):
    return [os.path.join(directory, filename)
      for filename in os.listdir(os.path.expanduser(directory))
      if filename.lower().endswith(".%s" % extension)]

from servers.model import ServerModel
from servers.view import ServerView

def entry_point():
    app = QApplication(sys.argv + ['-title','Transifex-mobile'])
    model = ServerModel("www.transifex.net", "Transifex.net")
    win = ServerView(model)
    win.show()
    sys.exit(app.exec_())

if __name__ == "__main__":
    entry_point()
