# -*- coding: utf-8 -*-

from PyQt4.QtCore import QAbstractListModel
from PyQt4.Qt import Qt
from common import QIconCache

class BookmarkListModel(QAbstractListModel):
    def __init__(self, server=None, parent=None):
        QAbstractListModel.__init__(self, parent=parent)
        self.server = server
        self.reset()

    def reset(self):
        self.objs = self.server.pullLocks()
        QAbstractListModel.reset(self)

    def rowCount(self, parent):
        return len(self.objs)

    def data(self, index, role=Qt.UserRole):
        if not index.isValid():
            return None
        row = index.row()
        if row < 0 or row >= len(self.objs):
            return None
        if role == Qt.DecorationRole:
            if self.objs[row].locked:
                return QIconCache.get("document-encrypt.svgz")
            else:
                return QIconCache.get("rating.svgz")
        if role == Qt.DisplayRole:
            return self.objs[row].long_title
        if role == Qt.UserRole:
            return self.objs[row]
        return None