# -*- coding: utf-8 -*-

class ProfileWindow(QCustomWindow):
    def __init__(self, parent=None):
        QCustomWindow.__init__(self, parent, title="My Profile")
        email = "lauri.vosandi@gmail.com"
        icon = QGravatar(email, 128)
        buttonAvatar = QPushButton(self)
        buttonAvatar.setIcon(icon)
        buttonAvatar.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        buttonAvatar.setFixedSize(128,128)
        
        self.username = QLineEdit()
        self.username.setCompleter(None)
        self.password = QLineEdit()
        self.password.setEchoMode(QLineEdit.Password)
        self.remember_password = QCheckBox("Remember password")
        self.email = QLineEdit()
        self.email.setCompleter(None)

        layout = QGridLayout()
        layout.addWidget(buttonAvatar,  0, 0, 2, 1)
        layout.addWidget(self.username, 0, 1)
        layout.addWidget(self.password, 1, 1)        
        layout.addWidget(QLabel("E-mail"), 2, 0)
        layout.addWidget(self.email, 2, 1)
        layout.addWidget(QPushButton("Save"), 0, 2)
        self.centralWidget().setLayout(layout)
