#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys, sqlite3, os
from utils.DebugLog import DebugLog
from utils.Config import TrainTrainConf
from PyQt4 import QtCore, QtGui 
from PyQt4.QtCore import Qt
from PyQt4.QtGui import QApplication
from TimePicker import TimePicker

class SettingsDlg(QtGui.QDialog ):
   def __init__(self):
      QtGui.QDialog.__init__(self)

      self.conf = TrainTrainConf()

      self.CreateLayouts()
      self.setModal(True)
      self.setWindowTitle(u'Paramètres')

   def CreateLayouts(self):
      hLayout = QtGui.QHBoxLayout()
      labelnb = QtGui.QLabel('Nombre max de trains par trajet')
      self.editnb = QtGui.QComboBox()
      elist = QtCore.QStringList()
      elist << '1' << '2' << '3' << '4'
      self.editnb.addItems(elist)
      idx = elist.indexOf('%d'%self.conf.nbTrains())
      self.editnb.setCurrentIndex(idx)
      hLayout.addWidget(labelnb)
      hLayout.addWidget(self.editnb)

      hLayout2 = QtGui.QHBoxLayout()
      labelra = QtGui.QLabel(u'Rafraîchissement auto')
      self.refresh = QtGui.QComboBox()
      rlist = QtCore.QStringList()
      rlist << '15 s' << '30 s' << '1 min' << '5 min'
      self.refresh.addItems(rlist)
      idx = rlist.indexOf(self.conf.refreshRate())
      self.refresh.setCurrentIndex(idx)
      hLayout2.addWidget(labelra)
      hLayout2.addWidget(self.refresh)

      hLayout3 = QtGui.QHBoxLayout()
      labelmor = QtGui.QLabel(u'Horaires Aller')

      time_m_f = QtCore.QTime.fromString(self.conf.morningInterval()[0], "HH:mm")
      time_m_t = QtCore.QTime.fromString(self.conf.morningInterval()[1], "HH:mm")
      time_e_f = QtCore.QTime.fromString(self.conf.eveningInterval()[0], "HH:mm")
      time_e_t = QtCore.QTime.fromString(self.conf.eveningInterval()[1], "HH:mm")
      
      self.morning_from = TimePicker()
      self.morning_from.setTime(time_m_f)

      self.morning_to = TimePicker()
      self.morning_to.setTime(time_m_t)

      hLayout3.addWidget(labelmor)
      hLayout3.addWidget(self.morning_from)
      hLayout3.addWidget(QtGui.QLabel(u'à'))
      hLayout3.addWidget(self.morning_to)

      hLayout4 = QtGui.QHBoxLayout()
      labeleve = QtGui.QLabel(u'Horaires Retour')
      
      self.evening_from = TimePicker()
      self.evening_from.setTime(time_e_f)

      self.evening_to = TimePicker()
      self.evening_to.setTime(time_e_t)

      hLayout4.addWidget(labeleve)
      hLayout4.addWidget(self.evening_from)
      hLayout4.addWidget(QtGui.QLabel(u'à'))
      hLayout4.addWidget(self.evening_to)
      
      vbox = QtGui.QVBoxLayout()
      vbox.addLayout(hLayout)
      vbox.addLayout(hLayout2)
      vbox.addLayout(hLayout3)
      vbox.addLayout(hLayout4)

      hLayout3 = QtGui.QHBoxLayout()
      buttons = QtGui.QDialogButtonBox()
      buttons.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
      self.connect(buttons, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.connect(buttons, QtCore.SIGNAL("rejected()"), self.OnCancel)

      hLayout3.addWidget(buttons)
      vbox.addLayout(hLayout3)

      self.setLayout(vbox)

   def OnOK(self):
      self.conf.SetNbTrains( self.editnb.currentText() )
      self.conf.SetRefreshRate( self.refresh.currentText() )

      self.conf.SetInvervals( (self.morning_from.time(), self.morning_to.time()),
                              (self.evening_from.time(), self.evening_to.time()) )
       
      self.conf.WriteConfig()
      self.accept()

   def OnCancel(self):
      self.reject()
