#!/usr/bin/python
# -*- coding: utf-8 -*-

import re, time, os
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import QAbstractTableModel, Qt, QVariant
from utils.DebugLog import DebugLog
from utils.TrainDb import  DbTrain, GareManager
from utils.Config import TrainTrainConf, ConfFile, RidesConfig
from extractors.ExtractorTransilien import ExtractorTransilien
from extractors.ExtractorMetro import ExtractorMetro
from extractors.ExtractorRERratp import ExtractorRERratp
from extractors.ExtractorTramway import ExtractorTramway

class TrainTrainModel(QAbstractTableModel):
   def __init__(self):
      QAbstractTableModel.__init__(self)
      DebugLog("TrainTrainModel::Init")

      self.labels = ['Train', 'Heure', 'Destination', 'Voie']

      confDir = os.path.join(os.path.expanduser('~'),".traintrain")
      if not os.path.exists(confDir):
         os.makedirs(confDir)

      self.ridesConfFile = os.path.join(confDir, "trajets.conf")

      self.garesConf = RidesConfig(self.ridesConfFile)
      self.rides = dict()
      self.db = DbTrain()
      self.gareMgr = GareManager(self.db)
      self.online = True
      self.ttConf = TrainTrainConf()
      self.max = self.ttConf.nbTrains()

   def ReadConfig(self):
      self.ttConf.ReadConfig()

   def GetRidesModel(self):
      return [self.rides[k] for k in sorted(self.rides.keys())]

   def AddRideModel(self, ridemodel):
      DebugLog("TrainTrainModel::AddRideModel")
      self.rides[ridemodel.id] = ridemodel

   def RemoveRideModel(self, rideModel):
      self.garesConf.RemoveRide(rideModel.id)
      del self.rides[rideModel.id]

   def InsertWarnings(self, rows):
      DebugLog("TrainTrainModel::InsertWarning")

      self.insertRows(0, len(rows), QtCore.QModelIndex)
      rowPos=0
      for row in rows:
         index = self.createIndex(rowPos, 0, QtCore.QModelIndex)
         self.setData(index, row[0], Qt.DisplayRole)
         rowPos += 1

      self.emit(QtCore.SIGNAL("dataChanged(index, index)"))

   def SetOnline(self, b):
      self.online = b

   def CreateAndAddRide(self, ligne, save=True):
      extractor = None
      if ligne.tec=='RER' and ligne.exploitant=='S':
         extractor = ExtractorTransilien(ligne)

      elif ligne.tec == 'Metro':
         extractor = ExtractorMetro(ligne)
         
      elif ligne.tec == 'Tramway':
         extractor = ExtractorTramway(ligne)

      elif ligne.tec == 'RER' and ligne.exploitant=='R': # RATP
         extractor = ExtractorRERratp(ligne)

      if extractor:
         extractor.rideModel.sens = ligne.sens
         self.rideList[extractor.id] = extractor
         if save:
            self.AddRideModel( extractor.rideModel )
         self.connect(extractor, QtCore.SIGNAL('extracted'), self.Extracted, QtCore.Qt.QueuedConnection)
         extractor.SetOnline(self.online)
         # extractor.FetchDatas(self, self.max)
         return extractor.rideModel
      else:
         return None

   def InitDatas(self):
      DebugLog("TrainTrainModel::InitDatas")
      self.garesConf.ReadRides()
      self.rideList = dict()
      self.reset()
      for ligne in self.garesConf.GetRides():
         self.CreateAndAddRide(ligne)
      DebugLog("initialized")
      self.emit(QtCore.SIGNAL('initialized'))   

   def Extracted(self, rideModel):
      self.emit(QtCore.SIGNAL('extracted'), rideModel)

   def RefreshDatas(self, id=''):
      DebugLog("TrainTrainModel::RefreshDatas")
      if id:
         self.rideList[id].FetchDatas(self, self.max)
      else:
         for extractor in self.rideList.values():
            extractor.FetchDatas(self, self.max)
