﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

from utils.DebugLog import DebugLog
from PyQt4 import QtCore

class Ride(QtCore.QObject):
   def __init__(self):
      QtCore.QObject.__init__(self)

      self.train = ''
      self.heure = ''
      self.destination = ''
      self.voie = ''
      self.error = ''
      self.noTrain = False
      self.match = True
      self.detailsUrl=''

   def setNoTrain(self, b):
      self.noTrain = b

   def setTrain(self, train):
      self.train = train

   def setHeure(self, heure):
      self.heure = heure

   def setDestination(self, destination):
      self.destination = destination

   def setVoie(self, voie):
      self.voie = voie

   def setError(self, error):
      self.error = error

   def __str__(self):
      return unicode('Train: %s, Heure: %s, Destination: %s, Voie: %s'%(self.train, self.heure, self.destination, self.voie))

   def SendMatch(self, reply):
      self.emit(QtCore.SIGNAL('match'), reply, self)

class RideModel(QtCore.QObject):
   def __init__(self, id):
      DebugLog("RideModel::__init__")
      QtCore.QObject.__init__(self)

      self.rides = []
      self.perturbations = []
      self.id = id
      self.read=0
      self.total=0
      self.sens=0
      self.progress=0.0

   def __str__(self):
      s = u''
      for ride in self.getRides():
         s += unicode(ride)+u'\n'
      return s

   def Clear(self):
      DebugLog("RideModel::Clear")
      self.rides = []
      self.perturbations = []

   def getUrl(self):
      t, l, s = self.icon
      rul = ''
      if t=='M':
         url = u"http://fr.wikipedia.org/wiki/Ligne_%s_du_métro_de_Paris"%l
      elif t=='R':
         url = u"http://fr.wikipedia.org/wiki/Ligne_%s_du_RER_d'Ile-de-France"%l
      elif t=='T':
         url = u"http://fr.wikipedia.org/wiki/Ligne_%s_du_tramway_d'Île-de-France"%l

      return QtCore.QUrl(url)

   def getIcon(self):
      return self.icon

   def getTitle(self):
      return self.title

   def getRides(self):
      return self.rides

   def getPerturbations(self):
      return self.perturbations

   def ClearPerturbations(self):
      self.perturbations = []

   def AddPerturbation(self, perturbation):
      self.perturbations.append(perturbation)

   def setIconTitle(self, icontitle):
      self.icon, self.title = icontitle

   def addRide(self, ride):
      self.rides.append(ride)

   def SetInfo(self, stype, text):
      self.emit(QtCore.SIGNAL('info'), stype, text)

   def SetProgress(self, read, total):
      self.read = read
      self.total = total
      if total>0:
         self.progress=float(100.0*read)/float(total)
      self.emit(QtCore.SIGNAL('progress'))
