#!/usr/bin/python
from ConfigParser import SafeConfigParser
import os.path

#tracker_cfg_file = os.path.expanduser('~/.config/tracker/tracker.cfg')
backup_file = os.path.expanduser('~/.config/tracker/tracker.cfg.ORIG')
tracker_cfg_file = os.path.abspath('tracker.cfg')

if os.path.exists(backup_file):
  cfg = SafeConfigParser()
  cfg.read(tracker_cfg_file)
  for s in ('WatchDirectoryRoots', 'CrawlDirectory', 'NoWatchDirectory'):
    v = cfg.get('Watches', s)
    nv = []
    for d in v.split(';'):
      if len(d)>0:
        if d[-1]!='/':
          d += '/'
        nv.append(d)
    cfg.set('Watches', s, ';'.join(nv)+';')

  fp = open(tracker_cfg_file, 'w')
  cfg.write(fp)
  fp.close()

