﻿ ## This program is free software; you can redistribute it and/or modify
 ## it under the terms of the GNU General Public License as published
 ## by the Free Software Foundation; version 2 or any later version.
 ##
 ## This program is distributed in the hope that it will be useful,
 ## but WITHOUT ANY WARRANTY; without even the implied warranty of
 ## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ## GNU General Public License for more details.
 ##
import hildon, gtk, gobject

class ListDialog(hildon.Dialog):
  def __init__(self, parent, title, strlist):
    hildon.Dialog.__init__(self)
    self.set_title(title)
    self.set_transient_for(parent)
    self.set_size_request(0,320)
    self.selector = hildon.TouchSelector(text = True)
    for d in strlist:
      self.selector.append_text(d)
    add_btn = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
               hildon.BUTTON_ARRANGEMENT_VERTICAL)
    add_btn.set_title('Add...')
    add_btn.connect('clicked', self._do_add)
    del_btn = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
               hildon.BUTTON_ARRANGEMENT_VERTICAL)
    del_btn.set_title('Remove')
    del_btn.connect('clicked', self._do_del)
    ok_btn = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
               hildon.BUTTON_ARRANGEMENT_VERTICAL)
    ok_btn.set_title('OK')
    ok_btn.connect_object('clicked', self.response, gtk.RESPONSE_ACCEPT)
    self.vbox.pack_start(self.selector)
    self.action_area.pack_end(add_btn)
    self.action_area.pack_end(del_btn)
    self.action_area.pack_end(ok_btn)
    self.show_all()
    
  def _do_del(self, e):
    d = self.selector.get_current_text()
    note = hildon.hildon_note_new_confirmation(self, \
      "Do you want to remove %s from the list?" % d)
    if gtk.Dialog.run(note)==gtk.RESPONSE_OK:
      model = self.selector.get_model(0)
      it = model.get_iter_first()
      while True:
        if d==model.get_value(it, 0):
          model.remove(it)
          break
        else:
          it = model.iter_next(it)
          if not it:
            break
    note.destroy()

  def _get_dirlist(self):
    return [r[0] for r in self.selector.get_model(0)]
    
  the_list = property(_get_dirlist)

class DirListDialog(ListDialog):

  def __init__(self, parent, title, strlist):
    ListDialog.__init__(self, parent, title, strlist)
    
  def _do_add(self, e):
    fcd = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
    fcd.set_title('Select directory')
    r = fcd.run()
    if r==gtk.RESPONSE_OK:
      self.selector.append_text(fcd.get_filename())
    fcd.destroy()

class TextEntryDialog(gtk.Dialog):

  def __init__(self, parent, title, pht=''):
    gtk.Dialog.__init__(self, title, parent, gtk.DIALOG_DESTROY_WITH_PARENT,
     (gtk.STOCK_OK,gtk.RESPONSE_OK))
    self.entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
    self.entry.set_placeholder(pht)
    self.vbox.pack_start(self.entry)
    self.show_all()
    
class StrListDialog(ListDialog):
  def __init__(self, parent, title, strlist):
    ListDialog.__init__(self, parent, title, strlist)
    
  def _do_add(self, e):
    ted = TextEntryDialog(self, 'Add new entry')
    r = ted.run()
    if r==gtk.RESPONSE_OK:
      self.selector.append_text(ted.entry.get_text())
    ted.destroy()
    
  