#include "tpsessionobserver.h"
#include "tpsession.h"
#include <TelepathyQt4/Channel>

TpSessionObserver::TpSessionObserver(const Tp::ChannelClassList &channelFilter,TpSession *session):Tp::AbstractClientObserver(channelFilter)
{
    tpSession=session;
    qDebug() << __PRETTY_FUNCTION__ ;
}

void TpSessionObserver::observeChannels(const Tp::MethodInvocationContextPtr<> &context,
            const Tp::AccountPtr &account,
            const Tp::ConnectionPtr &connection,
            const QList<Tp::ChannelPtr> &channels,
            const Tp::ChannelDispatchOperationPtr &dispatchOperation,
            const QList<Tp::ChannelRequestPtr> &requestsSatisfied,
            const QVariantMap &observerInfo)
{
    Q_UNUSED(dispatchOperation)
    Q_UNUSED(requestsSatisfied)
    Q_UNUSED(observerInfo)
    Q_UNUSED(connection)

    qDebug() << "TpSessionObserver::observeChannels";

    foreach(Tp::ChannelPtr channel, channels) {
    QVariantMap properties = channel->immutableProperties();
    QString channelType = properties.value(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType")).toString();
    if( !channelType.isNull() && !channelType.isEmpty()) {
          qDebug() << "ChannelType=" << channelType;
                tpSession->createChannelListener(channelType, context, account, channel);
            }
    }
}

