/*
 * This file is part of TpSession
 *
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * Contact Kate Alhola  kate.alholanokia.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "tpsessionchannel.h"

TpSessionChannel::TpSessionChannel(Tp::ConnectionPtr conn,const Tp::ContactPtr &contact)
{
    QVariantMap request;
    qDebug() << "TpSessionChannel::TpSessionChannel" <<"contact.id() " << contact->id();
    request.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType"),
                   TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT);
    request.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".TargetHandleType"),
                   (uint) Tp::HandleTypeContact);
    request.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".TargetHandle"),
                   contact->handle()[0]);

    connect(conn->ensureChannel(request),
            SIGNAL(finished(Tp::PendingOperation*)),
            SLOT(onChannelCreated(Tp::PendingOperation*)));
    peerContact=contact;
}



TpSessionChannel::TpSessionChannel(Tp::TextChannelPtr ch)
{
     qDebug() << "TpSessionChannel::TpSessionChannel" <<"path " << ch->objectPath();
     channel=ch;
     connect(channel->becomeReady(Tp::TextChannel::FeatureMessageQueue|Tp::TextChannel::FeatureMessageSentSignal),
                    SIGNAL(finished(Tp::PendingOperation *)),
                    SLOT(onChannelReady(Tp::PendingOperation *)));

}

void TpSessionChannel::onChannelCreated(Tp::PendingOperation *op)
{
   qDebug() << "TpSessionChannel::onOutgoingChannelCreated" ;
   if (op->isError()) {
     qWarning() << "Connection cannot become connected" ;
     return;
   }
   Tp::PendingChannel *pc = qobject_cast<Tp::PendingChannel *>(op);

   channel = Tp::TextChannel::create(pc->connection(),pc->objectPath(), pc->immutableProperties());

    connect(channel->becomeReady(Tp::TextChannel::FeatureMessageQueue | Tp::TextChannel::FeatureMessageSentSignal),
            SIGNAL(finished(Tp::PendingOperation*)),
            SLOT(onChannelReady(Tp::PendingOperation*)));
}

void TpSessionChannel::onChannelReady(Tp::PendingOperation *op)
{
 qDebug() << "TpSessionChannel::onChannelReady type=" << channel->channelType() <<"path " << channel->objectPath() <<
            "initiatorContact=" << (channel->initiatorContact() ? channel->initiatorContact()->id():"NULL") ;
         ;
 connect(channel.data(),
         SIGNAL(messageReceived(const Tp::ReceivedMessage &)),
         SLOT(onMessageReceived(const Tp::ReceivedMessage &)));
 connect(channel.data(),
         SIGNAL(messageSent(const Tp::Message &,Tp::MessageSendingFlags, const QString &)),
         SLOT(onMessageSent(const Tp::Message &,Tp::MessageSendingFlags, const QString &)));
 emit channelReady(this);
 peerContact=channel->initiatorContact();
 QList<Tp::ReceivedMessage> queuedMessages = channel->messageQueue();
 foreach(Tp::ReceivedMessage message, queuedMessages) {
      qDebug()  << "received " << message.text();
           emit messageReceived(message,this);
    }
}
void TpSessionChannel::sendMessage(QString message)
{
    channel->send(message);
}
void TpSessionChannel::onMessageReceived(const Tp::ReceivedMessage &msg)
{
    qDebug() << "TpSessionChannel::onMessageReceived " << msg.text();
    emit messageReceived(msg,this);
};
void TpSessionChannel::onMessageSent(const Tp::Message &msg,Tp::MessageSendingFlags sflags, const QString &flags)
{
    qDebug() << "TpSessionChannel::onMessageSent";
    emit messageSent(msg,sflags,flags,this);
};

QString TpSessionChannel::peerId()
{
    return peerContact ? peerContact->id():"";
}
