#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <Phonon>
#include <QtNetwork>
#include <QtSql>
#include "options.h"
#include "lastfm.h"
#include "lmaster.h"



#include <QEvent>
#ifdef Q_WS_MAEMO_5
#include <QtDBus>
#endif


#include "ui_mainwindow.h"

class MainWindow : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.tplayer")

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    Ui::MainWindow ui;
    Phonon::MediaObject *moo ;
    Phonon::AudioOutput *device;
    Phonon::SeekSlider *slider ;
    Phonon::VolumeSlider *volume;
    //QStringList list;
    QMenu *mmenu;
    QMap<int,QStringList> list;
    QMap<int,QStringList> ilist;
    QStringList queue;
    Phonon::MediaObject *metaInformationResolver;
    QProgressBar *loading;
    QDialog *ld;
    options *opt;
    lmaster *lmast;
    int rotate;
    int iload;
    last *scrobler;
    Phonon::VideoWidget *vwidget;


    QString currentQuery;
    QMenu *tmenu;
    QMap<QString,QString> autolist;
    QStringList namefilter;
    Phonon::Effect      *eqEffect;
    QList<QSlider*> sliders;
    Phonon::Path audioPath;
    int on_head_con;
    int on_head_dis;
    int on_start;
    int inet_source;
    QString current_path;
    QString track_title,track_artist,track_album;
    QString eq_name;
    QMenu *eq_menu;
signals:
    Q_SCRIPTABLE void track_change(QString );
public slots:
    void rem_eq();
    void eq_fn_click();
    void save_eq_d();
    void eq_load_mn();
    void load_eqs();
    void load_eq(QString);
    void save_eq();
    void save_eq(QString);


    void load_inet();
    void inet(QListWidgetItem*);
    void fmtx_change(int);
    void toggleEqualizer(bool);
    void sliderChanged (int);
    void resetAll ();
    void alistload();
    void load();
    void click1();
    void click2();
    void click3();
    void click4();
    void click5();
    void click6();
    void click7();
    void click8();


    void i_fn_click();
    void findi();
    void pl_sf_click();
    void pl_fn_click();
    void pl_fn_add_dir();
    void currentItemChanged ( QListWidgetItem * );
    Q_SCRIPTABLE void play_pause();
    Q_SCRIPTABLE void next();
    Q_SCRIPTABLE void prev();
    void changePlay( Phonon::State, Phonon::State ) ;
    void clear();
    void replyFinished(QNetworkReply*);
    void about();
    void drawlist();
    void getMeta(QString );
    void metaStateChanged(Phonon::State, Phonon::State);
    void ch();
    void find();
    void inform();
    void reload();
    #ifdef Q_WS_MAEMO_5
    void grabZoomKeys(bool grab);
    void headphoneEvent (QString,QString);
    void dbus (QString,QString);
    #endif
    void dart();
    void dart2();
    void replyFinished2(QNetworkReply*);
    void replyFinished3(QNetworkReply*);
    void kbdhelp();
    void orientationChanged();
protected:
  void keyPressEvent(QKeyEvent* event);
  bool eventFilter(QObject *obj, QEvent *event);

};

#endif // MAINWINDOW_H
