#include "options.h"

options::options( QWidget *parent) :
    QDialog(parent)
{
#ifdef Q_WS_MAEMO_5
base_path="/home/user/";
#else
#ifdef Q_OS_WIN32
base_path=qApp->applicationDirPath();
#else
#ifdef Q_WS_S60
base_path="/data/tplayer/";
#else
base_path="/usr/share/tplayer/";
#endif
#endif
#endif


    ui.setupUi(this);
connect(ui.pushButton,SIGNAL(clicked()),this,SLOT(save()));

QFile file(base_path+".tplayerrc");
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
            return;


        QStringList tyu=QString(file.readAll()).split("\n");
        while (tyu.count()<10)tyu.append("");

        ui.comboBox->setCurrentIndex(tyu.at(0).toLong());

        QFont h(tyu.at(1));

        ui.fontComboBox->setCurrentFont(h);
        ui.spinBox->setValue(tyu.at(2).toLong());

ui.lineEdit->setText(tyu.at(3));
ui.lineEdit_2->setText(tyu.at(4));
ui.lineEdit_3->setText(tyu.at(5));
ui.comboBox_2->setCurrentIndex(tyu.at(6).toLong());

ui.comboBox_3->setCurrentIndex(tyu.at(7).toLong());
ui.comboBox_4->setCurrentIndex(tyu.at(8).toLong());
ui.comboBox_5->setCurrentIndex(tyu.at(9).toLong());

file.close();
}

void options::load(int ci,QString cf,int cs){
ui.comboBox->setCurrentIndex(ci);
QFont* h=new QFont(QString(cf));

ui.fontComboBox->setCurrentFont(*h);
ui.spinBox->setValue(cs);

}

void options::save(){
    QFile file(base_path+".tplayerrc");
        if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
            return;

        QTextStream out(&file);
        out <<QString("%1\n%2\n%3\n%4\n%5\n%6\n%7\n" \
                      "%8\n%9\n%10\n").arg(ui.comboBox->currentIndex())
                .arg(ui.fontComboBox->currentFont().toString())
                .arg(ui.spinBox->value())
                .arg(ui.lineEdit->text())
                .arg(ui.lineEdit_2->text())
                .arg(ui.lineEdit_3->text())
                .arg(ui.comboBox_2->currentIndex())
                .arg(ui.comboBox_3->currentIndex())
                .arg(ui.comboBox_4->currentIndex())
                .arg(ui.comboBox_5->currentIndex());
        file.close();
        this->accept();
        this->close();
}
