/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>
#if QT_VERSION < 0x040600
#include <audiooutput.h>
#include <seekslider.h>
#include <mediaobject.h>
#include <volumeslider.h>
#include <backendcapabilities.h>
#include <effect.h>
#include <effectparameter.h>
#else
#include <phonon/audiooutput.h>
#include <phonon/seekslider.h>
#include <phonon/mediaobject.h>
#include <phonon/volumeslider.h>
#include <phonon/backendcapabilities.h>
#include <phonon/effect.h>
#include <phonon/effectparameter.h>
#include <QtDBus>
#endif
#include <QList>
#include <QTimer>
#include "playlistmanager.h"
#include "mainwindowactions.h"

class QAction;
class QTableWidget;
class QLCDNumber;


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow ();

    QSize sizeHint() const
    {
        return QSize(800, 480);
    }

public slots:
    void play();
    void pause() { mediaObject->pause (); }
    void stop();
    void next();
    void previous();
    void repeatToggle ();
    void shuffleToggle ();
    void volumeToggle ();
    void showAddMenu();
    void enqueueSelected();
    void controlsToggled ();
    void addFiles();
    void addFolder();
    void addUrl ();
    void savePlaylist ();
    void loadPlaylist ();
    void clearPlaylist () { plman.clearPlaylist (); }
    void showOptions ();
    void showEqualizer ();
    void upSelected();
    void downSelected();
    void removeSelectedItem ();
    void about();
    
private slots:
    void stateChanged(Phonon::State newState, Phonon::State oldState);
    void tick(qint64 time);
    void sourceChanged(const Phonon::MediaSource &source);
    void aboutToFinish();
    void finished();
    void tableClicked(int row, int column);
    void cellClicked(int row, int column);
    void playlistChanged (int from);
    void itemUpdated (int index);
    void setItem (int ind, bool doplay);
    void removeAllButSelectedItem ();
    void highlightRow (int i);
    void unhighlightRow (int i);

    void itemRemoved (int i);
    void playlistControl (const QString&);
    void orientationChanged();
    void headphoneEvent (QString,QString);
    void hideVolumeBar();
    
    void equalizerChanged (int ind, int val);
    void toggleEqualizer(bool);

protected:
    void contextMenuEvent (QContextMenuEvent*e);
private:
    void setupActions();
    void setupMenus();
    void setupUi();
    void setupShuffleList();
    void setRowFromItem (int row, const PlaylistItem& item);
    void buttonUp (int i);
    void buttonDown (int i);
    void buttonDel (int i);
    void setOrientation ();

    Phonon::SeekSlider *seekSlider;
    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    Phonon::VolumeSlider *volumeSlider;
    Phonon::Effect      *eqEffect;
    Phonon::Path audioPath;
    
    PlaylistManager plman;

    QToolBar *bar;
    QLCDNumber *timeLcd;
    QTableWidget *musicTable;
    QMenu   *contextMenu;
    QMenu   *addMenu;
    QStringList headers;
    bool        repeat;
    bool        shuffle;
    QSettings settings;
    QList<int>  shuffleList;
    int lastPlayed;
    bool isPlaying;
    bool portrait;
    bool autostopped;
    QTimer timer;
    MainWindowActions* mwa;
};

#endif
