#include <QtGui>
#include "optiondialog.h"

OptionDialog::OptionDialog(QWidget *parent, QSettings& set) :
    QDialog(parent), settings (set)
{
    availableHeaders = settings.value("headerOrder", QStringList()).toStringList();
    if (!availableHeaders.size())
        availableHeaders << "Artist" << "Title" << "Album" << "Controls";
    setupUi();
#ifdef Q_WS_MAEMO_5
    QString orient = settings.value("orientation", "Automatic").toString();
    if (orient == "Portrait")
    {
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    }
    else if (orient == "Landscape")
    {
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    }
    else
    {
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    }
#endif
}

OptionDialog::~OptionDialog ()
{
#ifdef Q_WS_MAEMO_5
    settings.setValue("orientation", orient->currentText());
#endif
    settings.setValue("headerOrder", availableHeaders);
    QStringList h;
    foreach (QObject* child, children())
    {
        QCheckBox* cb = qobject_cast<QCheckBox*>(child);
        if (cb && cb->isChecked () && availableHeaders.indexOf(cb->text()) >= 0)
        {
            h << cb->text ();
        }
    }
    settings.setValue("headers", h);
    settings.setValue("rowHeight", rowHeight->itemData(rowHeight->currentIndex()));
}


void OptionDialog::setupUi()
{
    QVBoxLayout *mainLayout = new QVBoxLayout;
    QHBoxLayout *subLayout;
#ifdef Q_WS_MAEMO_5
    QString ori = settings.value("orientation", "Automatic").toString();
    orient = new QComboBox();
    orient->addItem(tr ("Automatic"));
    orient->addItem(tr ("Landscape"));
    orient->addItem(tr ("Portrait"));
    if (ori == "Landscape")
        orient->setCurrentIndex(1);
    if (ori == "Portrait")
        orient->setCurrentIndex(2);
    QLabel *label = new QLabel (tr ("Orientation"));
    subLayout = new QHBoxLayout;
    subLayout->addWidget(label);
    subLayout->addWidget(orient);
    mainLayout->addLayout(subLayout);
    hpsense = new QCheckBox (tr ("Headphone sense"));
    hpsense->setChecked(settings.value("headphoneSense", false).toBool());
    connect (hpsense, SIGNAL(toggled(bool)), this, SLOT(headphoneSenseToggle(bool)));
    mainLayout->addWidget(hpsense);
#endif
    rowHeight = new QComboBox();
    rowHeight->addItem(tr ("Tiny"), 14);
    rowHeight->addItem(tr ("Small"), 20);
    rowHeight->addItem(tr ("Normal"), 24);
    rowHeight->addItem(tr ("Large"), 32);
    rowHeight->addItem(tr ("Huge"), 48);
    rowHeight->setCurrentIndex(rowHeight->findData(settings.value("rowHeight", DEFAULT_ROW_HEIGHT).toInt()));
    subLayout = new QHBoxLayout;
    subLayout->addWidget (new QLabel (tr ("Playlist font size")));
    subLayout->addWidget(rowHeight);
    mainLayout->addLayout(subLayout);
    QLabel* lab = new QLabel (tr ("Enabled columns: "));
    QHBoxLayout *sub = new QHBoxLayout;
    sub->addWidget(lab);
    headerLayout = new QVBoxLayout;
    QStringList headers = settings.value ("headers", QStringList ()).toStringList();
    if (!headers.size())
        headers = availableHeaders.mid(0, 3);
    foreach (QString str, availableHeaders)
    {
        QHBoxLayout *cont = new QHBoxLayout;
        QCheckBox* box = new QCheckBox (str);
        if (headers.indexOf(str) >= 0)
            box->setChecked(true);
        QLabel* label = new QLabel;
        label->setText(QString::fromUtf8("<b><a style='text-decoration:none' href='up'>▲</a> <a style='text-decoration:none' href='down'>▼</a></b>"));
        label->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
        label->setProperty("row", str);
        cont->addWidget(box);
        cont->addWidget(label);
        headerLayout->addLayout(cont);
        connect (label, SIGNAL(linkActivated(QString)), this, SLOT (orderControl(QString)));
    }
    sub->addLayout(headerLayout);
    mainLayout->addLayout(sub);
//    mainLayout->setSizeConstraint(QLayout::SetNoConstraint);
    setLayout(mainLayout);
/*    QVBoxLayout* l = new QVBoxLayout;
    QScrollArea *sa = new QScrollArea;
    sa->setLayout(mainLayout);
    l->addWidget(sa);
    setLayout (l);*/
    setWindowTitle("Settings");
}

void OptionDialog::orderControl (QString link)
{
    QString str = sender ()->property("row").toString();
    int i = availableHeaders.indexOf(str);
    if (link == "up" && i > 0)
    {
        QString tmp = availableHeaders[i];
        availableHeaders[i] = availableHeaders[i - 1];
        availableHeaders[i - 1] = tmp;
    }
    else if (link == "down" && i < availableHeaders.size() - 1)
    {
        QString tmp = availableHeaders[i];
        availableHeaders[i] = availableHeaders[i + 1];
        availableHeaders[i + 1] = tmp;
    }
    QStringList h;
    foreach (QObject* child, children())
    {
        QCheckBox* cb = qobject_cast<QCheckBox*>(child);
        if (cb && cb->isChecked ())
        {
            h << cb->text ();
        }
    }
    settings.setValue("headers", h);
    delete layout ();
    foreach (QObject* child, children ())
        delete child;
    setupUi();
}

void OptionDialog::headphoneSenseToggle (bool v)
{
    settings.setValue("headphoneSense", v);
}
