#ifndef NOWPLAYINGBUTTON_H
#define NOWPLAYINGBUTTON_H

#include "../mediaplayer/mobility/mediaplayer.h"
#include <QWidget>

class StackedWindow;

class NowPlayingButton : public QWidget
{
    Q_OBJECT

public:
    explicit NowPlayingButton(StackedWindow *parent = 0);
    ~NowPlayingButton();

    bool ready() const;

    static NowPlayingButton* instance();

public slots:
    void poke();

private:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);
    void paintEvent(QPaintEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    void triggerAnimation();
    void stopAnimation();
    void setReady(bool ready);
    bool moved() const;
    void setMoved(bool moved);
    
private slots:
    void onMediaStateChanged(Media::State state);
    void onPlaybackQueueChanged(int count);
    void onCurrentWindowChanged(StackedWindow *window);
    void onScreenLockStateChanged(bool locked);
    void onScreenOrientationChanged();
    void nextFrame();
    void showNowPlayingWindow();

signals:
    void readyChanged(bool ready);

private:
    static NowPlayingButton* m_instance;

    QTimer *m_animationTimer;

    int m_currentFrame;

    QVector<QPixmap> m_images;

    bool m_ready;
    bool m_moved;
};

#endif // NOWPLAYINGBUTTON_H
