#include "musiclistdelegate.h"
#include <QPainter>

MusicListDelegate::MusicListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void MusicListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 8);
    textRect.setRight(textRect.right() - 64);

    QFont font;
    font.setBold(true);
    painter->setFont(font);
    painter->drawText(textRect, Qt::AlignVCenter, index.data().toString());

    QRect imageRect = option.rect;
    imageRect.setTopLeft(QPoint(imageRect.right() - 56, imageRect.top() + 16));
    imageRect.setSize(QSize(48, 48));

    painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_forward.png"));

    painter->restore();
}

QSize MusicListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
