#include "artistlistdelegate.h"
#include "../shared/artistmodel.h"
#include <QPainter>
#include <QMaemo5Style>

ArtistListDelegate::ArtistListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ArtistListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

    QImage artwork = index.data(ArtistRoles::ArtworkRole).value<QImage>();

    if (artwork.isNull()) {
        artwork = QImage("/usr/share/icons/hicolor/64x64/hildon/mediaplayer_default_album.png");
    }

    painter->drawImage(iconRect, artwork);

    QRect textRect = option.rect;
    textRect.moveTopLeft(QPoint(textRect.left() + 80, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 8);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(ArtistRoles::NameRole).toString());

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignBottom, tr("%1 songs").arg(index.data(ArtistRoles::SongCountRole).toInt()));
    painter->restore();
}

QSize ArtistListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
