#include "abstracttab.h"
#include "windowstack.h"
#include "stackedwindow.h"
#include <QApplication>
#include <QDesktopWidget>

AbstractTab::AbstractTab(QWidget *parent) :
    QWidget(parent),
    m_portrait(false)
{
    this->connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(onOrientationChanged()));
}

void AbstractTab::onOrientationChanged() {
    QRect screen = QApplication::desktop()->screenGeometry();

    if (screen.width() > screen.height()) {
        m_portrait = false;
        this->setLandscapeLayout();
    }
    else {
        m_portrait = true;
        this->setPortraitLayout();
    }
}

void AbstractTab::toggleBusy(bool busy) {
    if (WindowStack::instance()->currentWindow()) {
        WindowStack::instance()->currentWindow()->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
    }
}
