#ifndef PLAYBACKQUEUEMODEL_H
#define PLAYBACKQUEUEMODEL_H

#include "songmodel.h"

using namespace QtUbuntuOne;

class PlaybackQueueModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

    friend class MediaPlayer;

public:
    ~PlaybackQueueModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, int role) const;

    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, int role);

    QMap<int, QVariant> itemData(const QModelIndex &index) const;
    Q_INVOKABLE QMap<int, QVariant> itemData(int row) const;

    Song* get(const QModelIndex &index) const;
    Q_INVOKABLE Song* get(int row) const;

public slots:
    void clear();

private slots:
    void onArtworkReady();

private:
    explicit PlaybackQueueModel(QObject *parent = 0);

    void appendSong(Song *song);
    void appendSongs(QList<Song*> songs);

    void insertSong(int i, Song *song);
    void insertSongs(int i, QList<Song*> songs);

    void removeSong(int i);
    void removeSongs(int i, int count);

signals:
    void countChanged(int count);

private:
    ArtworkCache *m_cache;

    QList<Song*> m_list;

    QHash<int, QByteArray> m_roleNames;
};

#endif // PLAYBACKQUEUEMODEL_H
