#ifndef NOTIFICATIONS_H
#define NOTIFICATIONS_H

#include <QObject>

class Notifications : public QObject
{
    Q_OBJECT

public:
    ~Notifications();

    static Notifications* instance();

    Q_INVOKABLE static void showInformation(const QString &message);
    Q_INVOKABLE static void showError(const QString &message);

signals:
    void information(const QString &message);
    void error(const QString &message);

private:
    Notifications();

    static Notifications *m_instance;
};

#endif // NOTIFICATIONS_H
