#ifndef SONGINFOWINDOW_H
#define SONGINFOWINDOW_H

#include "stackedwindow.h"
#include "song.h"

using namespace QtUbuntuOne;

class QLabel;
class SeparatorLabel;
class ArtworkLabel;
class ScrollArea;
class QAction;
class ArtworkCache;

class SongInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit SongInfoWindow(Song *song, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void playSong();
    void queueSong();

    void setArtwork();
    
private:
    Song *m_song;

    QAction *m_queueAction;

    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    QLabel *m_genreLabel;
    QLabel *m_formatLabel;
    QLabel *m_sizeLabel;
    QLabel *m_lengthLabel;

    ArtworkCache *m_cache;

    ArtworkLabel *m_artworkLabel;
    SeparatorLabel *m_propertiesSeparator;

    ScrollArea *m_scrollArea;
};

#endif // SONGINFOWINDOW_H
