#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "stackedwindow.h"

class FilesTab;
class MusicTab;
class QStackedWidget;
class QActionGroup;

class MainWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);

private:
    void clearMenuActions();

private slots:
    void showFilesTab();
    void showMusicTab();
    void showTransfers();
    void showSettingsDialog();
    void showAccountDialog();
    void showAboutDialog();
    
private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_filesAction;
    QAction *m_musicAction;
    QAction *m_transfersAction;
    QAction *m_settingsAction;
    QAction *m_accountAction;
    QAction *m_aboutAction;

    QStackedWidget *m_stack;
    FilesTab *m_filesTab;
    MusicTab *m_musicTab;
};

#endif // MAINWINDOW_H
