#include "mainwindow.h"
#include "filestab.h"
#include "musictab.h"
#include "aboutdialog.h"
#include "settingsdialog.h"
#include "accountdialog.h"
#include "authenticationdialog.h"
#include "transferlistwindow.h"
#include "authentication.h"
#include "../shared/storage.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenuBar>

MainWindow::MainWindow(QWidget *parent) :
    StackedWindow(parent),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_filesAction(new QAction(tr("Files"), this)),
    m_musicAction(new QAction(tr("Music"), this)),
    m_transfersAction(new QAction(tr("Transfers"), this)),
    m_settingsAction(new QAction(tr("Settings"), this)),
    m_accountAction(new QAction(tr("Account"), this)),
    m_aboutAction(new QAction(tr("About"), this)),
    m_stack(new QStackedWidget(this)),
    m_filesTab(new FilesTab(this)),
    m_musicTab(0)
{
    this->setWindowTitle("toBuntu");
    this->setAttribute(Qt::WA_DeleteOnClose, false);
    this->setCentralWidget(m_stack);

    m_filesAction->setCheckable(true);
    m_filesAction->setActionGroup(m_actionGroup);
    m_musicAction->setCheckable(true);
    m_musicAction->setActionGroup(m_actionGroup);

    m_actionGroup->setExclusive(true);

    m_filesAction->setChecked(true);

    m_menu->addAction(m_filesAction);
    m_menu->addAction(m_musicAction);
    m_menu->addAction(m_transfersAction);
    m_menu->addAction(m_settingsAction);
    m_menu->addAction(m_accountAction);
    m_menu->addAction(m_aboutAction);

    m_stack->setFrameStyle(QFrame::NoFrame);
    m_stack->addWidget(m_filesTab);

    this->connect(m_filesAction, SIGNAL(triggered()), this, SLOT(showFilesTab()));
    this->connect(m_musicAction, SIGNAL(triggered()), this, SLOT(showMusicTab()));
    this->connect(m_transfersAction, SIGNAL(triggered()), this, SLOT(showTransfers()));
    this->connect(m_settingsAction, SIGNAL(triggered()), this, SLOT(showSettingsDialog()));
    this->connect(m_accountAction, SIGNAL(triggered()), this, SLOT(showAccountDialog()));
    this->connect(m_aboutAction, SIGNAL(triggered()), this, SLOT(showAboutDialog()));

    this->showFilesTab();
}

void MainWindow::clearMenuActions() {
    if (m_menu->actions().size() > 2) {
        QAction *action = m_menu->actions().at(2);

        while ((action) && (action != m_transfersAction)) {
            m_menu->removeAction(action);

            if (m_menu->actions().size() > 2) {
                action = m_menu->actions().at(2);
            }
        }
    }
}

void MainWindow::showFilesTab() {
    m_stack->setCurrentWidget(m_filesTab);
    this->clearMenuActions();
    m_menu->insertActions(m_transfersAction, m_filesTab->actions());
}

void MainWindow::showMusicTab() {
    if (!m_musicTab) {
        m_musicTab = new MusicTab(this);
        m_stack->addWidget(m_musicTab);
    }

    m_stack->setCurrentWidget(m_musicTab);
    this->clearMenuActions();
    m_menu->insertActions(m_transfersAction, m_musicTab->actions());
}

void MainWindow::showTransfers() {
    TransferListWindow *window = new TransferListWindow(this);
    window->show();
}

void MainWindow::showSettingsDialog() {
    SettingsDialog *dialog = new SettingsDialog(this);
    dialog->open();
}

void MainWindow::showAccountDialog() {
    if (Authentication::tokenKey().isEmpty()) {
        AuthenticationDialog *dialog = new AuthenticationDialog(this);
        dialog->show();
    }
    else {
        AccountDialog *dialog = new AccountDialog(this);
        dialog->show();
        dialog->getAccount();
    }
}

void MainWindow::showAboutDialog() {
    AboutDialog *dialog = new AboutDialog(this);
    dialog->open();
}
