#include "mainwindow.h"
#include "authentication.h"
#include "../shared/settings.h"
#include "../shared/nodemodel.h"
#include "../shared/transfermanager.h"
#include "../shared/definitions.h"
#include "../shared/storage.h"
#include <QApplication>
#include <QTranslator>
#include <QDebug>

int main(int argc, char *argv[]) {
    QApplication app(argc, argv);
    app.setOrganizationName("toBuntu");
    app.setApplicationName("toBuntu");
    app.setApplicationVersion(VERSION_NUMBER);

    QTranslator translator;

    if (translator.load(QString("/opt/tobuntu/translations/%1.qm").arg(Settings::instance()->language()))) {
        app.installTranslator(&translator);
    }
    else {
        qWarning() << "No translation found for chosen language";
    }

    QScopedPointer<TransferManager> transferManager(TransferManager::instance());
    QScopedPointer<Settings> settings(Settings::instance());
    QScopedPointer<NodeModel> nodeModel(NodeModel::instance());

    Storage::init();
    Acc account = Storage::getAccount("toBuntu");
    Authentication::setCredentials(account.consumerKey,
                                   account.consumerSecret,
                                   account.tokenKey,
                                   account.tokenSecret);

    QTimer::singleShot(3000, TransferManager::instance(), SLOT(restoreStoredTransfers()));

    MainWindow window;
    window.show();

    return app.exec();
}
