#ifndef ALBUMLISTWINDOW_H
#define ALBUMLISTWINDOW_H

#include "stackedwindow.h"

class AlbumModel;
class ListView;
class QLabel;
class QModelIndex;

class AlbumListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit AlbumListWindow(QWidget *parent = 0);

public:
    void getAlbums();
    void getArtistAlbums(const QString &artistId);
    
private:
    void showEvent(QShowEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);

    void onItemClicked(const QModelIndex &index);

private:
    AlbumModel *m_model;
    ListView *m_view;

    QLabel *m_noResultsLabel;
};

#endif // ALBUMLISTWINDOW_H
