#include "albumlistwindow.h"
#include "albumsongswindow.h"
#include "listview.h"
#include "albumlistdelegate.h"
#include "nowplayingbutton.h"
#include "../shared/albummodel.h"
#include <QLabel>
#include <QMaemo5Style>

AlbumListWindow::AlbumListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_model(new AlbumModel(this)),
    m_view(new ListView(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No albums found")), this))
{
    this->setWindowTitle(tr("Albums"));
    this->setCentralWidget(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new AlbumListDelegate(m_view));
    m_view->setMonitorScrolling(true);
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_view, SIGNAL(scrollingStarted()), NowPlayingButton::instance(), SLOT(hide()));
    this->connect(m_view, SIGNAL(scrollingStopped()), NowPlayingButton::instance(), SLOT(poke()));

    this->onOrientationChanged();
}

void AlbumListWindow::showEvent(QShowEvent *event) {
    this->onLoadingChanged(m_model->loading());
    StackedWindow::showEvent(event);
}

void AlbumListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void AlbumListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void AlbumListWindow::getAlbums() {
    m_model->getAlbums();
}

void AlbumListWindow::getArtistAlbums(const QString &artistId) {
    m_model->getArtistAlbums(artistId);
}

void AlbumListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void AlbumListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void AlbumListWindow::onItemClicked(const QModelIndex &index) {
    AlbumSongsWindow *window = new AlbumSongsWindow(m_model->get(index), this);
    window->show();
}
