#ifndef STORAGE_H
#define STORAGE_H

#include "filetransfer.h"
#include <QObject>

using namespace QtUbuntuOne;

struct Acc {
    QString tokenName;
    QString consumerKey;
    QString consumerSecret;
    QString tokenKey;
    QString tokenSecret;
};

class Storage : public QObject
{
    Q_OBJECT

public:
    explicit Storage(QObject *parent = 0);
    ~Storage();

    Q_INVOKABLE static void init();

    Q_INVOKABLE static bool storeAccount(const QString &tokenName,
                      const QString &consumerKey,
                      const QString &consumerSecret,
                      const QString &tokenKey,
                      const QString &tokenSecret);

    Q_INVOKABLE static bool storeAccount(Acc account);

    Q_INVOKABLE static bool removeAccount(const QString &tokenName);

    Q_INVOKABLE static Acc getAccount(const QString &tokenName);
    Q_INVOKABLE static QVariantMap getAccountMap(const QString &tokenName);

    Q_INVOKABLE static bool storeTransfers(QList<FileTransfer*> transfers);
    Q_INVOKABLE static QList<FileTransfer*> restoreTransfers();
    Q_INVOKABLE static bool clearStoredTransfers();
};

#endif // STORAGE_H
